/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.configuration.internal.metadata.reader;

import java.lang.annotation.Annotation;
import java.util.Iterator;
import org.hibernate.MappingException;
import org.hibernate.annotations.common.reflection.ClassLoadingException;
import org.hibernate.annotations.common.reflection.ReflectionManager;
import org.hibernate.annotations.common.reflection.XClass;
import org.hibernate.envers.AuditTable;
import org.hibernate.envers.Audited;
import org.hibernate.envers.ModificationStore;
import org.hibernate.envers.SecondaryAuditTable;
import org.hibernate.envers.SecondaryAuditTables;
import org.hibernate.envers.configuration.internal.GlobalConfiguration;
import org.hibernate.envers.configuration.internal.metadata.reader.AuditedPropertiesReader;
import org.hibernate.envers.configuration.internal.metadata.reader.ClassAuditingData;
import org.hibernate.envers.configuration.internal.metadata.reader.PersistentPropertiesSource;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;

public final class AnnotationsMetadataReader {
    private final GlobalConfiguration globalCfg;
    private final ReflectionManager reflectionManager;
    private final PersistentClass pc;
    private final ClassAuditingData auditData;
    private AuditTable defaultAuditTable = new AuditTable(){

        @Override
        public String value() {
            return "";
        }

        @Override
        public String schema() {
            return "";
        }

        @Override
        public String catalog() {
            return "";
        }

        @Override
        public Class<? extends Annotation> annotationType() {
            return this.getClass();
        }
    };

    public AnnotationsMetadataReader(GlobalConfiguration globalCfg, ReflectionManager reflectionManager, PersistentClass pc) {
        this.globalCfg = globalCfg;
        this.reflectionManager = reflectionManager;
        this.pc = pc;
        this.auditData = new ClassAuditingData();
    }

    private ModificationStore getDefaultAudited(XClass clazz) {
        Audited defaultAudited = (Audited)clazz.getAnnotation(Audited.class);
        if (defaultAudited != null) {
            return defaultAudited.modStore();
        }
        return null;
    }

    private void addAuditTable(XClass clazz) {
        AuditTable auditTable = (AuditTable)clazz.getAnnotation(AuditTable.class);
        if (auditTable != null) {
            this.auditData.setAuditTable(auditTable);
        } else {
            this.auditData.setAuditTable(this.getDefaultAuditTable());
        }
    }

    private void addAuditSecondaryTables(XClass clazz) {
        SecondaryAuditTables secondaryAuditTables;
        SecondaryAuditTable secondaryVersionsTable1 = (SecondaryAuditTable)clazz.getAnnotation(SecondaryAuditTable.class);
        if (secondaryVersionsTable1 != null) {
            this.auditData.getSecondaryTableDictionary().put(secondaryVersionsTable1.secondaryTableName(), secondaryVersionsTable1.secondaryAuditTableName());
        }
        if ((secondaryAuditTables = (SecondaryAuditTables)clazz.getAnnotation(SecondaryAuditTables.class)) != null) {
            for (SecondaryAuditTable secondaryAuditTable2 : secondaryAuditTables.value()) {
                this.auditData.getSecondaryTableDictionary().put(secondaryAuditTable2.secondaryTableName(), secondaryAuditTable2.secondaryAuditTableName());
            }
        }
    }

    public ClassAuditingData getAuditData() {
        if (this.pc.getClassName() == null) {
            return this.auditData;
        }
        try {
            XClass xclass = this.reflectionManager.classForName(this.pc.getClassName());
            ModificationStore defaultStore = this.getDefaultAudited(xclass);
            if (defaultStore != null) {
                this.auditData.setDefaultAudited(true);
            }
            new AuditedPropertiesReader(defaultStore, new PersistentClassPropertiesSource(xclass), this.auditData, this.globalCfg, this.reflectionManager, "").read();
            this.addAuditTable(xclass);
            this.addAuditSecondaryTables(xclass);
        }
        catch (ClassLoadingException e) {
            throw new MappingException((Throwable)e);
        }
        return this.auditData;
    }

    private AuditTable getDefaultAuditTable() {
        return this.defaultAuditTable;
    }

    private class PersistentClassPropertiesSource
    implements PersistentPropertiesSource {
        private final XClass xclass;

        private PersistentClassPropertiesSource(XClass xclass) {
            this.xclass = xclass;
        }

        @Override
        public Iterator<Property> getPropertyIterator() {
            return AnnotationsMetadataReader.this.pc.getPropertyIterator();
        }

        @Override
        public Property getProperty(String propertyName) {
            return AnnotationsMetadataReader.this.pc.getProperty(propertyName);
        }

        @Override
        public XClass getXClass() {
            return this.xclass;
        }
    }
}

