/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.revisioninfo;

import java.io.Serializable;
import java.util.Date;
import org.hibernate.MappingException;
import org.hibernate.Session;
import org.hibernate.envers.EntityTrackingRevisionListener;
import org.hibernate.envers.RevisionListener;
import org.hibernate.envers.RevisionType;
import org.hibernate.envers.entities.PropertyData;
import org.hibernate.envers.revisioninfo.RevisionInfoGenerator;
import org.hibernate.envers.synchronization.SessionCacheCleaner;
import org.hibernate.envers.tools.reflection.ReflectionTools;
import org.hibernate.property.Setter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultRevisionInfoGenerator
implements RevisionInfoGenerator {
    private final String revisionInfoEntityName;
    private final RevisionListener listener;
    private final Setter revisionTimestampSetter;
    private final boolean timestampAsDate;
    private final Class<?> revisionInfoClass;
    private final SessionCacheCleaner sessionCacheCleaner;

    public DefaultRevisionInfoGenerator(String revisionInfoEntityName, Class<?> revisionInfoClass, Class<? extends RevisionListener> listenerClass, PropertyData revisionInfoTimestampData, boolean timestampAsDate) {
        this.revisionInfoEntityName = revisionInfoEntityName;
        this.revisionInfoClass = revisionInfoClass;
        this.timestampAsDate = timestampAsDate;
        this.revisionTimestampSetter = ReflectionTools.getSetter(revisionInfoClass, revisionInfoTimestampData);
        if (!listenerClass.equals(RevisionListener.class)) {
            try {
                this.listener = listenerClass.newInstance();
            }
            catch (InstantiationException e) {
                throw new MappingException((Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new MappingException((Throwable)e);
            }
        } else {
            this.listener = null;
        }
        this.sessionCacheCleaner = new SessionCacheCleaner();
    }

    @Override
    public void saveRevisionData(Session session, Object revisionData) {
        session.save(this.revisionInfoEntityName, revisionData);
        this.sessionCacheCleaner.scheduleAuditDataRemoval(session, revisionData);
    }

    @Override
    public Object generate() {
        Object revisionInfo;
        try {
            revisionInfo = this.revisionInfoClass.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        long timestamp = System.currentTimeMillis();
        this.revisionTimestampSetter.set(revisionInfo, (Object)(this.timestampAsDate ? new Date(timestamp) : Long.valueOf(timestamp)), null);
        if (this.listener != null) {
            this.listener.newRevision(revisionInfo);
        }
        return revisionInfo;
    }

    @Override
    public void entityChanged(Class entityClass, String entityName, Serializable entityId, RevisionType revisionType, Object revisionInfo) {
        if (this.listener instanceof EntityTrackingRevisionListener) {
            ((EntityTrackingRevisionListener)this.listener).entityChanged(entityClass, entityName, entityId, revisionType, revisionInfo);
        }
    }
}

