/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpa.criteria.expression;

import java.io.Serializable;
import org.hibernate.jpa.criteria.CriteriaBuilderImpl;
import org.hibernate.jpa.criteria.ParameterRegistry;
import org.hibernate.jpa.criteria.ValueHandlerFactory;
import org.hibernate.jpa.criteria.compile.RenderingContext;
import org.hibernate.jpa.criteria.expression.ExpressionImpl;

public class LiteralExpression<T>
extends ExpressionImpl<T>
implements Serializable {
    private Object literal;

    public LiteralExpression(CriteriaBuilderImpl criteriaBuilder, T literal) {
        this(criteriaBuilder, LiteralExpression.determineClass(literal), literal);
    }

    private static Class determineClass(Object literal) {
        return literal == null ? null : literal.getClass();
    }

    public LiteralExpression(CriteriaBuilderImpl criteriaBuilder, Class<T> type, T literal) {
        super(criteriaBuilder, type);
        this.literal = literal;
    }

    public T getLiteral() {
        return (T)this.literal;
    }

    @Override
    public void registerParameters(ParameterRegistry registry) {
    }

    @Override
    public String render(RenderingContext renderingContext) {
        if (ValueHandlerFactory.isNumeric(this.literal)) {
            return ValueHandlerFactory.determineAppropriateHandler(this.literal.getClass()).render(this.literal);
        }
        String parameterName = renderingContext.registerLiteralParameterBinding(this.getLiteral(), this.getJavaType());
        return ':' + parameterName;
    }

    @Override
    public String renderProjection(RenderingContext renderingContext) {
        ValueHandlerFactory.ValueHandler<?> handler = ValueHandlerFactory.determineAppropriateHandler(this.literal.getClass());
        if (ValueHandlerFactory.isCharacter(this.literal)) {
            return '\'' + handler.render(this.literal) + '\'';
        }
        return handler.render(this.literal);
    }

    @Override
    protected void resetJavaType(Class targetType) {
        super.resetJavaType(targetType);
        ValueHandlerFactory.ValueHandler<Object> valueHandler = this.getValueHandler();
        if (valueHandler == null) {
            valueHandler = ValueHandlerFactory.determineAppropriateHandler(targetType);
            this.forceConversion(valueHandler);
        }
        if (valueHandler != null) {
            this.literal = valueHandler.convert(this.literal);
        }
    }
}

