/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.source.annotations.xml.mocker;

import java.util.ArrayList;
import org.hibernate.metamodel.source.annotation.jaxb.XMLAccessType;
import org.hibernate.metamodel.source.annotation.jaxb.XMLGeneratedValue;
import org.hibernate.metamodel.source.annotation.jaxb.XMLId;
import org.hibernate.metamodel.source.annotations.xml.mocker.EntityMappingsMocker;
import org.hibernate.metamodel.source.annotations.xml.mocker.IndexBuilder;
import org.hibernate.metamodel.source.annotations.xml.mocker.MockHelper;
import org.hibernate.metamodel.source.annotations.xml.mocker.PropertyMocker;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;

class IdMocker
extends PropertyMocker {
    private XMLId id;

    IdMocker(IndexBuilder indexBuilder, ClassInfo classInfo, EntityMappingsMocker.Default defaults, XMLId id) {
        super(indexBuilder, classInfo, defaults);
        this.id = id;
    }

    @Override
    protected void processExtra() {
        this.create(ID);
        this.parserColumn(this.id.getColumn(), this.getTarget());
        this.parserGeneratedValue(this.id.getGeneratedValue(), this.getTarget());
        this.parserTemporalType(this.id.getTemporal(), this.getTarget());
    }

    private AnnotationInstance parserGeneratedValue(XMLGeneratedValue generatedValue, AnnotationTarget target) {
        if (generatedValue == null) {
            return null;
        }
        ArrayList<AnnotationValue> annotationValueList = new ArrayList<AnnotationValue>();
        MockHelper.stringValue("generator", generatedValue.getGenerator(), annotationValueList);
        MockHelper.enumValue("strategy", GENERATION_TYPE, generatedValue.getStrategy(), annotationValueList);
        return this.create(GENERATED_VALUE, target, annotationValueList);
    }

    @Override
    protected String getFieldName() {
        return this.id.getName();
    }

    @Override
    protected XMLAccessType getAccessType() {
        return this.id.getAccess();
    }

    @Override
    protected void setAccessType(XMLAccessType accessType) {
        this.id.setAccess(accessType);
    }
}

