/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.source.annotations.xml.mocker;

import java.util.List;
import java.util.Map;
import org.hibernate.AssertionFailure;
import org.hibernate.MappingException;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.metamodel.source.annotation.jaxb.XMLAccessType;
import org.hibernate.metamodel.source.annotations.JPADotNames;
import org.hibernate.metamodel.source.annotations.JandexHelper;
import org.hibernate.metamodel.source.annotations.xml.PseudoJpaDotNames;
import org.hibernate.metamodel.source.annotations.xml.mocker.IndexBuilder;
import org.hibernate.metamodel.source.annotations.xml.mocker.MockHelper;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;
import org.jboss.logging.Logger;

class AccessHelper
implements JPADotNames {
    private static final CoreMessageLogger LOG = (CoreMessageLogger)Logger.getMessageLogger(CoreMessageLogger.class, (String)AccessHelper.class.getName());

    AccessHelper() {
    }

    static XMLAccessType getAccessFromDefault(IndexBuilder indexBuilder) {
        AnnotationInstance annotationInstance = JandexHelper.getSingleAnnotation(indexBuilder.getAnnotations(), PseudoJpaDotNames.DEFAULT_ACCESS);
        if (annotationInstance == null) {
            return null;
        }
        return JandexHelper.getEnumValue(annotationInstance, "value", XMLAccessType.class);
    }

    static XMLAccessType getAccessFromIdPosition(DotName className, IndexBuilder indexBuilder) {
        Map<DotName, List<AnnotationInstance>> indexedAnnotations = indexBuilder.getIndexedAnnotations(className);
        Map<DotName, List<AnnotationInstance>> ormAnnotations = indexBuilder.getClassInfoAnnotationsMap(className);
        XMLAccessType accessType = AccessHelper.getAccessFromIdPosition(ormAnnotations);
        if (accessType == null) {
            accessType = AccessHelper.getAccessFromIdPosition(indexedAnnotations);
        }
        if (accessType == null) {
            ClassInfo parent = indexBuilder.getClassInfo(className);
            if (parent == null) {
                parent = indexBuilder.getIndexedClassInfo(className);
            }
            if (parent != null) {
                DotName parentClassName = parent.superName();
                accessType = AccessHelper.getAccessFromIdPosition(parentClassName, indexBuilder);
            }
        }
        return accessType;
    }

    private static XMLAccessType getAccessFromIdPosition(Map<DotName, List<AnnotationInstance>> annotations) {
        if (annotations == null || annotations.isEmpty() || !annotations.containsKey(ID)) {
            return null;
        }
        List<AnnotationInstance> idAnnotationInstances = annotations.get(ID);
        if (MockHelper.isNotEmpty(idAnnotationInstances)) {
            return AccessHelper.processIdAnnotations(idAnnotationInstances);
        }
        return null;
    }

    private static XMLAccessType processIdAnnotations(List<AnnotationInstance> idAnnotations) {
        XMLAccessType accessType = null;
        for (AnnotationInstance annotation : idAnnotations) {
            AnnotationTarget tmpTarget = annotation.target();
            if (tmpTarget == null) {
                throw new AssertionFailure("@Id has no AnnotationTarget, this is mostly a internal error.");
            }
            if (accessType == null) {
                accessType = AccessHelper.annotationTargetToAccessType(tmpTarget);
                continue;
            }
            if (accessType.equals((Object)AccessHelper.annotationTargetToAccessType(tmpTarget))) continue;
            throw new MappingException("Inconsistent placement of @Id annotation within hierarchy ");
        }
        return accessType;
    }

    static XMLAccessType annotationTargetToAccessType(AnnotationTarget target) {
        return target instanceof MethodInfo ? XMLAccessType.PROPERTY : XMLAccessType.FIELD;
    }

    static XMLAccessType getEntityAccess(DotName className, IndexBuilder indexBuilder) {
        Map<DotName, List<AnnotationInstance>> indexedAnnotations = indexBuilder.getIndexedAnnotations(className);
        Map<DotName, List<AnnotationInstance>> ormAnnotations = indexBuilder.getClassInfoAnnotationsMap(className);
        XMLAccessType accessType = AccessHelper.getAccess(ormAnnotations);
        if (accessType == null) {
            accessType = AccessHelper.getAccess(indexedAnnotations);
        }
        if (accessType == null) {
            ClassInfo parent = indexBuilder.getClassInfo(className);
            if (parent == null) {
                parent = indexBuilder.getIndexedClassInfo(className);
            }
            if (parent != null) {
                DotName parentClassName = parent.superName();
                accessType = AccessHelper.getEntityAccess(parentClassName, indexBuilder);
            }
        }
        return accessType;
    }

    private static XMLAccessType getAccess(Map<DotName, List<AnnotationInstance>> annotations) {
        if (annotations == null || annotations.isEmpty() || !AccessHelper.isEntityObject(annotations)) {
            return null;
        }
        List<AnnotationInstance> accessAnnotationInstances = annotations.get(JPADotNames.ACCESS);
        if (MockHelper.isNotEmpty(accessAnnotationInstances)) {
            for (AnnotationInstance annotationInstance : accessAnnotationInstances) {
                if (annotationInstance.target() == null || !(annotationInstance.target() instanceof ClassInfo)) continue;
                return JandexHelper.getEnumValue(annotationInstance, "value", XMLAccessType.class);
            }
        }
        return null;
    }

    private static boolean isEntityObject(Map<DotName, List<AnnotationInstance>> annotations) {
        return annotations.containsKey(ENTITY) || annotations.containsKey(MAPPED_SUPERCLASS) || annotations.containsKey(EMBEDDABLE);
    }

    static XMLAccessType getAccessFromAttributeAnnotation(DotName className, String attributeName, IndexBuilder indexBuilder) {
        List<AnnotationInstance> annotationInstances;
        Map<DotName, List<AnnotationInstance>> indexedAnnotations = indexBuilder.getIndexedAnnotations(className);
        if (indexedAnnotations != null && indexedAnnotations.containsKey(ACCESS) && MockHelper.isNotEmpty(annotationInstances = indexedAnnotations.get(ACCESS))) {
            for (AnnotationInstance annotationInstance : annotationInstances) {
                XMLAccessType targetAccessType;
                AnnotationTarget indexedPropertyTarget = annotationInstance.target();
                if (indexedPropertyTarget == null || !JandexHelper.getPropertyName(indexedPropertyTarget).equals(attributeName)) continue;
                XMLAccessType accessType = JandexHelper.getEnumValue(annotationInstance, "value", XMLAccessType.class);
                if (accessType.equals((Object)(targetAccessType = AccessHelper.annotationTargetToAccessType(indexedPropertyTarget)))) {
                    return targetAccessType;
                }
                LOG.warn(String.format("%s.%s has @Access on %s, but it tries to assign the access type to %s, this is not allowed by JPA spec, and will be ignored.", new Object[]{className, attributeName, targetAccessType, accessType}));
            }
        }
        return null;
    }
}

