/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.integrator.internal;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ServiceConfigurationError;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.service.classloading.spi.ClassLoaderService;
import org.jboss.logging.Logger;

final class ServiceLoader<S>
implements Iterable<S> {
    private static final CoreMessageLogger LOG = (CoreMessageLogger)Logger.getMessageLogger(CoreMessageLogger.class, (String)ServiceLoader.class.getName());
    private static final String PREFIX = "META-INF/services/";
    private LinkedHashMap<String, S> providers = new LinkedHashMap();

    private ServiceLoader(Class<S> svc, ServiceRegistry serviceRegistry) {
        Class<S> service = svc;
        ClassLoaderService loader = serviceRegistry.getService(ClassLoaderService.class);
        String fullName = PREFIX + service.getName();
        service.getName();
        List<URL> configs = this.locateResources(loader, fullName);
        for (URL url : configs) {
            Iterator<String> names = this.parse(service, url);
            while (names.hasNext()) {
                String cn = names.next();
                try {
                    S p = service.cast(loader.classForName(cn).newInstance());
                    this.providers.put(cn, p);
                }
                catch (Throwable x) {
                    ServiceLoader.fail(service, "Provider " + cn + " could not be instantiated: " + x, x);
                }
            }
        }
    }

    private List<URL> locateResources(ClassLoaderService loader, String fullName) {
        ArrayList<URL> urls = new ArrayList<URL>();
        urls.addAll(loader.locateResources(fullName));
        try {
            Enumeration<URL> hibUrls = ServiceLoader.class.getClassLoader().getResources(fullName);
            while (hibUrls.hasMoreElements()) {
                URL u = hibUrls.nextElement();
                if (urls.contains(u)) continue;
                urls.add(u);
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        return urls;
    }

    private static void fail(Class service, String msg, Throwable cause) throws ServiceConfigurationError {
        throw new ServiceConfigurationError(service.getName() + ": " + msg, cause);
    }

    private static void fail(Class service, String msg) throws ServiceConfigurationError {
        throw new ServiceConfigurationError(service.getName() + ": " + msg);
    }

    private static void fail(Class service, URL u, int line, String msg) throws ServiceConfigurationError {
        ServiceLoader.fail(service, u + ":" + line + ": " + msg);
    }

    private int parseLine(Class service, URL u, BufferedReader r, int lc, List<String> names) throws IOException, ServiceConfigurationError {
        int n;
        String ln = r.readLine();
        if (ln == null) {
            return -1;
        }
        int ci = ln.indexOf(35);
        if (ci >= 0) {
            ln = ln.substring(0, ci);
        }
        if ((n = (ln = ln.trim()).length()) != 0) {
            int cp;
            if (ln.indexOf(32) >= 0 || ln.indexOf(9) >= 0) {
                ServiceLoader.fail(service, u, lc, "Illegal configuration-file syntax");
            }
            if (!Character.isJavaIdentifierStart(cp = ln.codePointAt(0))) {
                ServiceLoader.fail(service, u, lc, "Illegal provider-class name: " + ln);
            }
            for (int i = Character.charCount(cp); i < n; i += Character.charCount(cp)) {
                cp = ln.codePointAt(i);
                if (Character.isJavaIdentifierPart(cp) || cp == 46) continue;
                ServiceLoader.fail(service, u, lc, "Illegal provider-class name: " + ln);
            }
            if (!this.providers.containsKey(ln) && !names.contains(ln)) {
                names.add(ln);
            }
        }
        return lc + 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Iterator<String> parse(Class service, URL u) throws ServiceConfigurationError {
        InputStream in = null;
        BufferedReader r = null;
        ArrayList<String> names = new ArrayList<String>();
        try {
            in = u.openStream();
            r = new BufferedReader(new InputStreamReader(in, "utf-8"));
            int lc = 1;
            while ((lc = this.parseLine(service, u, r, lc, names)) >= 0) {
            }
        }
        catch (IOException x) {
            ServiceLoader.fail(service, "Error reading configuration file", x);
        }
        finally {
            try {
                if (r != null) {
                    r.close();
                }
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException y) {
                ServiceLoader.fail(service, "Error closing configuration file", y);
            }
        }
        return names.iterator();
    }

    @Override
    public Iterator<S> iterator() {
        return this.providers.values().iterator();
    }

    public static <S> ServiceLoader<S> load(Class<S> service, ServiceRegistry serviceRegistry) {
        return new ServiceLoader<S>(service, serviceRegistry);
    }
}

