/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.jdbc.internal;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.Connection;
import java.sql.SQLException;
import org.hibernate.HibernateException;
import org.hibernate.engine.jdbc.batch.spi.Batch;
import org.hibernate.engine.jdbc.batch.spi.BatchBuilder;
import org.hibernate.engine.jdbc.batch.spi.BatchKey;
import org.hibernate.engine.jdbc.internal.LogicalConnectionImpl;
import org.hibernate.engine.jdbc.internal.StatementPreparerImpl;
import org.hibernate.engine.jdbc.spi.JdbcCoordinator;
import org.hibernate.engine.jdbc.spi.LogicalConnectionImplementor;
import org.hibernate.engine.jdbc.spi.SqlExceptionHelper;
import org.hibernate.engine.jdbc.spi.StatementPreparer;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.transaction.internal.TransactionCoordinatorImpl;
import org.hibernate.engine.transaction.spi.TransactionContext;
import org.hibernate.engine.transaction.spi.TransactionCoordinator;
import org.hibernate.engine.transaction.spi.TransactionEnvironment;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.jdbc.WorkExecutor;
import org.hibernate.jdbc.WorkExecutorVisitable;
import org.jboss.logging.Logger;

public class JdbcCoordinatorImpl
implements JdbcCoordinator {
    private static final CoreMessageLogger LOG = (CoreMessageLogger)Logger.getMessageLogger(CoreMessageLogger.class, (String)JdbcCoordinatorImpl.class.getName());
    private transient TransactionCoordinatorImpl transactionCoordinator;
    private final transient LogicalConnectionImpl logicalConnection;
    private transient Batch currentBatch;
    private int flushDepth = 0;
    private transient StatementPreparer statementPreparer;

    public JdbcCoordinatorImpl(Connection userSuppliedConnection, TransactionCoordinatorImpl transactionCoordinator) {
        this.transactionCoordinator = transactionCoordinator;
        this.logicalConnection = new LogicalConnectionImpl(userSuppliedConnection, transactionCoordinator.getTransactionContext().getConnectionReleaseMode(), transactionCoordinator.getTransactionContext().getTransactionEnvironment().getJdbcServices(), transactionCoordinator.getTransactionContext().getJdbcConnectionAccess());
    }

    private JdbcCoordinatorImpl(LogicalConnectionImpl logicalConnection) {
        this.logicalConnection = logicalConnection;
    }

    @Override
    public TransactionCoordinator getTransactionCoordinator() {
        return this.transactionCoordinator;
    }

    @Override
    public LogicalConnectionImplementor getLogicalConnection() {
        return this.logicalConnection;
    }

    protected TransactionEnvironment transactionEnvironment() {
        return this.getTransactionCoordinator().getTransactionContext().getTransactionEnvironment();
    }

    protected SessionFactoryImplementor sessionFactory() {
        return this.transactionEnvironment().getSessionFactory();
    }

    protected BatchBuilder batchBuilder() {
        return this.sessionFactory().getServiceRegistry().getService(BatchBuilder.class);
    }

    private SqlExceptionHelper sqlExceptionHelper() {
        return this.transactionEnvironment().getJdbcServices().getSqlExceptionHelper();
    }

    @Override
    public void flushBeginning() {
        if (this.flushDepth == 0) {
            this.logicalConnection.disableReleases();
        }
        ++this.flushDepth;
    }

    @Override
    public void flushEnding() {
        --this.flushDepth;
        if (this.flushDepth < 0) {
            throw new HibernateException("Mismatched flush handling");
        }
        if (this.flushDepth == 0) {
            this.logicalConnection.enableReleases();
        }
    }

    @Override
    public Connection close() {
        if (this.currentBatch != null) {
            LOG.closingUnreleasedBatch();
            this.currentBatch.release();
        }
        return this.logicalConnection.close();
    }

    @Override
    public Batch getBatch(BatchKey key) {
        if (this.currentBatch != null) {
            if (this.currentBatch.getKey().equals(key)) {
                return this.currentBatch;
            }
            this.currentBatch.execute();
            this.currentBatch.release();
        }
        this.currentBatch = this.batchBuilder().buildBatch(key, this);
        return this.currentBatch;
    }

    @Override
    public void abortBatch() {
        if (this.currentBatch != null) {
            this.currentBatch.release();
        }
    }

    @Override
    public StatementPreparer getStatementPreparer() {
        if (this.statementPreparer == null) {
            this.statementPreparer = new StatementPreparerImpl(this);
        }
        return this.statementPreparer;
    }

    @Override
    public void setTransactionTimeOut(int timeOut) {
        this.getStatementPreparer().setTransactionTimeOut(timeOut);
    }

    @Override
    public void afterTransaction() {
        this.logicalConnection.afterTransaction();
        if (this.statementPreparer != null) {
            this.statementPreparer.unsetTransactionTimeOut();
        }
    }

    @Override
    public <T> T coordinateWork(WorkExecutorVisitable<T> work) {
        Connection connection = this.getLogicalConnection().getDistinctConnectionProxy();
        try {
            T result = work.accept(new WorkExecutor(), connection);
            this.getLogicalConnection().afterStatementExecution();
            T t = result;
            return t;
        }
        catch (SQLException e) {
            throw this.sqlExceptionHelper().convert(e, "error executing work");
        }
        finally {
            try {
                if (!connection.isClosed()) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                LOG.debug("Error closing connection proxy", e);
            }
        }
    }

    @Override
    public void executeBatch() {
        if (this.currentBatch != null) {
            this.currentBatch.execute();
            this.currentBatch.release();
        }
    }

    @Override
    public void cancelLastQuery() {
        this.logicalConnection.getResourceRegistry().cancelLastQuery();
    }

    public void serialize(ObjectOutputStream oos) throws IOException {
        if (!this.logicalConnection.isReadyForSerialization()) {
            throw new HibernateException("Cannot serialize Session while connected");
        }
        this.logicalConnection.serialize(oos);
    }

    public static JdbcCoordinatorImpl deserialize(ObjectInputStream ois, TransactionContext transactionContext) throws IOException, ClassNotFoundException {
        return new JdbcCoordinatorImpl(LogicalConnectionImpl.deserialize(ois, transactionContext));
    }

    public void afterDeserialize(TransactionCoordinatorImpl transactionCoordinator) {
        this.transactionCoordinator = transactionCoordinator;
    }
}

