/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg.beanvalidation;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.hibernate.HibernateException;
import org.hibernate.cfg.Configuration;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.event.service.spi.EventListenerRegistry;
import org.hibernate.integrator.spi.Integrator;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.metamodel.source.MetadataImplementor;
import org.hibernate.service.classloading.spi.ClassLoaderService;
import org.hibernate.service.spi.SessionFactoryServiceRegistry;
import org.jboss.logging.Logger;

public class BeanValidationIntegrator
implements Integrator {
    private static final CoreMessageLogger LOG = (CoreMessageLogger)Logger.getMessageLogger(CoreMessageLogger.class, (String)BeanValidationIntegrator.class.getName());
    public static final String APPLY_CONSTRAINTS = "hibernate.validator.apply_to_ddl";
    public static final String BV_CHECK_CLASS = "javax.validation.Validation";
    public static final String MODE_PROPERTY = "javax.persistence.validation.mode";
    private static final String ACTIVATOR_CLASS = "org.hibernate.cfg.beanvalidation.TypeSafeActivator";
    private static final String DDL_METHOD = "applyDDL";
    private static final String ACTIVATE_METHOD = "activateBeanValidation";
    private static final String VALIDATE_METHOD = "validateFactory";

    public static void validateFactory(Object object) {
        try {
            Class<?> activatorClass = BeanValidationIntegrator.class.getClassLoader().loadClass(ACTIVATOR_CLASS);
            try {
                Method validateMethod = activatorClass.getMethod(VALIDATE_METHOD, Object.class);
                if (!validateMethod.isAccessible()) {
                    validateMethod.setAccessible(true);
                }
                try {
                    validateMethod.invoke(null, object);
                }
                catch (InvocationTargetException e) {
                    if (e.getTargetException() instanceof HibernateException) {
                        throw (HibernateException)e.getTargetException();
                    }
                    throw new HibernateException("Unable to check validity of passed ValidatorFactory", e);
                }
                catch (IllegalAccessException e) {
                    throw new HibernateException("Unable to check validity of passed ValidatorFactory", e);
                }
            }
            catch (HibernateException e) {
                throw e;
            }
            catch (Exception e) {
                throw new HibernateException("Could not locate method needed for ValidatorFactory validation", e);
            }
        }
        catch (HibernateException e) {
            throw e;
        }
        catch (Exception e) {
            throw new HibernateException("Could not locate TypeSafeActivator class", e);
        }
    }

    @Override
    public void integrate(Configuration configuration, SessionFactoryImplementor sessionFactory, SessionFactoryServiceRegistry serviceRegistry) {
        boolean isBeanValidationAvailable;
        Set<ValidationMode> modes = ValidationMode.getModes(configuration.getProperties().get(MODE_PROPERTY));
        ClassLoaderService classLoaderService = serviceRegistry.getService(ClassLoaderService.class);
        try {
            classLoaderService.classForName(BV_CHECK_CLASS);
            isBeanValidationAvailable = true;
        }
        catch (Exception e) {
            isBeanValidationAvailable = false;
        }
        Class typeSafeActivatorClass = this.loadTypeSafeActivatorClass(serviceRegistry);
        this.applyRelationalConstraints(modes, isBeanValidationAvailable, typeSafeActivatorClass, configuration);
        this.applyHibernateListeners(modes, isBeanValidationAvailable, typeSafeActivatorClass, configuration, sessionFactory, serviceRegistry);
    }

    @Override
    public void integrate(MetadataImplementor metadata, SessionFactoryImplementor sessionFactory, SessionFactoryServiceRegistry serviceRegistry) {
    }

    private Class loadTypeSafeActivatorClass(SessionFactoryServiceRegistry serviceRegistry) {
        try {
            return serviceRegistry.getService(ClassLoaderService.class).classForName(ACTIVATOR_CLASS);
        }
        catch (Exception e) {
            return null;
        }
    }

    private void applyRelationalConstraints(Set<ValidationMode> modes, boolean beanValidationAvailable, Class typeSafeActivatorClass, Configuration configuration) {
        if (!ConfigurationHelper.getBoolean(APPLY_CONSTRAINTS, configuration.getProperties(), true)) {
            LOG.debug("Skipping application of relational constraints from legacy Hibernate Validator");
            return;
        }
        if (!modes.contains((Object)ValidationMode.DDL) && !modes.contains((Object)ValidationMode.AUTO)) {
            return;
        }
        if (!beanValidationAvailable) {
            if (modes.contains((Object)ValidationMode.DDL)) {
                throw new HibernateException("Bean Validation not available in the class path but required in javax.persistence.validation.mode");
            }
            if (modes.contains((Object)ValidationMode.AUTO)) {
                return;
            }
        }
        try {
            Method applyDDLMethod = typeSafeActivatorClass.getMethod(DDL_METHOD, Collection.class, Properties.class);
            try {
                applyDDLMethod.invoke(null, configuration.createMappings().getClasses().values(), configuration.getProperties());
            }
            catch (HibernateException e) {
                throw e;
            }
            catch (Exception e) {
                throw new HibernateException("Error applying BeanValidation relational constraints", e);
            }
        }
        catch (HibernateException e) {
            throw e;
        }
        catch (Exception e) {
            throw new HibernateException("Unable to locate TypeSafeActivator#applyDDL method", e);
        }
    }

    private void applyHibernateListeners(Set<ValidationMode> modes, boolean beanValidationAvailable, Class typeSafeActivatorClass, Configuration configuration, SessionFactoryImplementor sessionFactory, SessionFactoryServiceRegistry serviceRegistry) {
        if (configuration.getProperty("hibernate.check_nullability") == null) {
            sessionFactory.getSettings().setCheckNullability(false);
        }
        if (!modes.contains((Object)ValidationMode.CALLBACK) && !modes.contains((Object)ValidationMode.AUTO)) {
            return;
        }
        if (!beanValidationAvailable) {
            if (modes.contains((Object)ValidationMode.CALLBACK)) {
                throw new HibernateException("Bean Validation not available in the class path but required in javax.persistence.validation.mode");
            }
            if (modes.contains((Object)ValidationMode.AUTO)) {
                return;
            }
        }
        try {
            Method activateMethod = typeSafeActivatorClass.getMethod(ACTIVATE_METHOD, EventListenerRegistry.class, Configuration.class);
            try {
                activateMethod.invoke(null, serviceRegistry.getService(EventListenerRegistry.class), configuration);
            }
            catch (HibernateException e) {
                throw e;
            }
            catch (Exception e) {
                throw new HibernateException("Error applying BeanValidation relational constraints", e);
            }
        }
        catch (HibernateException e) {
            throw e;
        }
        catch (Exception e) {
            throw new HibernateException("Unable to locate TypeSafeActivator#applyDDL method", e);
        }
    }

    @Override
    public void disintegrate(SessionFactoryImplementor sessionFactory, SessionFactoryServiceRegistry serviceRegistry) {
    }

    private static enum ValidationMode {
        AUTO,
        CALLBACK,
        NONE,
        DDL;


        public static Set<ValidationMode> getModes(Object modeProperty) {
            HashSet<ValidationMode> modes = new HashSet<ValidationMode>(3);
            if (modeProperty == null) {
                modes.add(AUTO);
            } else {
                String[] modesInString;
                for (String modeInString : modesInString = modeProperty.toString().split(",")) {
                    modes.add(ValidationMode.getMode(modeInString));
                }
            }
            if (modes.size() > 1 && (modes.contains((Object)AUTO) || modes.contains((Object)NONE))) {
                StringBuilder message = new StringBuilder("Incompatible validation modes mixed: ");
                for (ValidationMode mode : modes) {
                    message.append((Object)mode).append(", ");
                }
                throw new HibernateException(message.substring(0, message.length() - 2));
            }
            return modes;
        }

        private static ValidationMode getMode(String modeProperty) {
            if (modeProperty == null || modeProperty.length() == 0) {
                return AUTO;
            }
            try {
                return ValidationMode.valueOf(modeProperty.trim().toUpperCase());
            }
            catch (IllegalArgumentException e) {
                throw new HibernateException("Unknown validation mode in javax.persistence.validation.mode: " + modeProperty);
            }
        }
    }
}

