/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import org.hibernate.ConnectionReleaseMode;
import org.hibernate.EntityMode;
import org.hibernate.HibernateException;
import org.hibernate.bytecode.BytecodeProvider;
import org.hibernate.bytecode.cglib.BytecodeProviderImpl;
import org.hibernate.cache.QueryCacheFactory;
import org.hibernate.cache.RegionFactory;
import org.hibernate.cache.impl.NoCachingRegionFactory;
import org.hibernate.cache.impl.bridge.RegionFactoryCacheProviderBridge;
import org.hibernate.cfg.Settings;
import org.hibernate.connection.ConnectionProvider;
import org.hibernate.connection.ConnectionProviderFactory;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.resolver.DialectFactory;
import org.hibernate.engine.jdbc.JdbcSupport;
import org.hibernate.engine.jdbc.JdbcSupportLoader;
import org.hibernate.exception.SQLExceptionConverter;
import org.hibernate.exception.SQLExceptionConverterFactory;
import org.hibernate.hql.QueryTranslatorFactory;
import org.hibernate.jdbc.BatcherFactory;
import org.hibernate.jdbc.BatchingBatcherFactory;
import org.hibernate.jdbc.NonBatchingBatcherFactory;
import org.hibernate.jdbc.util.SQLStatementLogger;
import org.hibernate.transaction.TransactionFactory;
import org.hibernate.transaction.TransactionFactoryFactory;
import org.hibernate.transaction.TransactionManagerLookup;
import org.hibernate.transaction.TransactionManagerLookupFactory;
import org.hibernate.util.PropertiesHelper;
import org.hibernate.util.ReflectHelper;
import org.hibernate.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SettingsFactory
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(SettingsFactory.class);
    private static final long serialVersionUID = -1194386144994524825L;
    public static final String DEF_CACHE_REG_FACTORY = NoCachingRegionFactory.class.getName();

    protected SettingsFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Settings buildSettings(Properties props) {
        SQLExceptionConverter sqlExceptionConverter;
        ConnectionReleaseMode releaseMode;
        Settings settings = new Settings();
        String sessionFactoryName = props.getProperty("hibernate.session_factory_name");
        settings.setSessionFactoryName(sessionFactoryName);
        ConnectionProvider connections = this.createConnectionProvider(props);
        settings.setConnectionProvider(connections);
        boolean metaSupportsScrollable = false;
        boolean metaSupportsGetGeneratedKeys = false;
        boolean metaSupportsBatchUpdates = false;
        boolean metaReportsDDLCausesTxnCommit = false;
        boolean metaReportsDDLInTxnSupported = true;
        Dialect dialect = null;
        JdbcSupport jdbcSupport = null;
        boolean useJdbcMetadata = PropertiesHelper.getBoolean("hibernate.temp.use_jdbc_metadata_defaults", props, true);
        if (useJdbcMetadata) {
            try {
                Connection conn = connections.getConnection();
                try {
                    DatabaseMetaData meta = conn.getMetaData();
                    log.info("Database ->\n       name : " + meta.getDatabaseProductName() + '\n' + "    version : " + meta.getDatabaseProductVersion() + '\n' + "      major : " + meta.getDatabaseMajorVersion() + '\n' + "      minor : " + meta.getDatabaseMinorVersion());
                    log.info("Driver ->\n       name : " + meta.getDriverName() + '\n' + "    version : " + meta.getDriverVersion() + '\n' + "      major : " + meta.getDriverMajorVersion() + '\n' + "      minor : " + meta.getDriverMinorVersion());
                    dialect = DialectFactory.buildDialect(props, conn);
                    jdbcSupport = JdbcSupportLoader.loadJdbcSupport(conn);
                    metaSupportsScrollable = meta.supportsResultSetType(1004);
                    metaSupportsBatchUpdates = meta.supportsBatchUpdates();
                    metaReportsDDLCausesTxnCommit = meta.dataDefinitionCausesTransactionCommit();
                    metaReportsDDLInTxnSupported = !meta.dataDefinitionIgnoredInTransactions();
                    metaSupportsGetGeneratedKeys = meta.supportsGetGeneratedKeys();
                }
                catch (SQLException sqle) {
                    log.warn("Could not obtain connection metadata", (Throwable)sqle);
                }
                finally {
                    connections.closeConnection(conn);
                }
            }
            catch (SQLException sqle) {
                log.warn("Could not obtain connection to query metadata", (Throwable)sqle);
                dialect = DialectFactory.buildDialect(props);
            }
            catch (UnsupportedOperationException uoe) {
                dialect = DialectFactory.buildDialect(props);
            }
        } else {
            dialect = DialectFactory.buildDialect(props);
        }
        settings.setDataDefinitionImplicitCommit(metaReportsDDLCausesTxnCommit);
        settings.setDataDefinitionInTransactionSupported(metaReportsDDLInTxnSupported);
        settings.setDialect(dialect);
        if (jdbcSupport == null) {
            jdbcSupport = JdbcSupportLoader.loadJdbcSupport(null);
        }
        settings.setJdbcSupport(jdbcSupport);
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)dialect.getDefaultProperties());
        properties.putAll((Map<?, ?>)props);
        TransactionFactory transactionFactory = this.createTransactionFactory(properties);
        settings.setTransactionFactory(transactionFactory);
        settings.setTransactionManagerLookup(this.createTransactionManagerLookup(properties));
        boolean flushBeforeCompletion = PropertiesHelper.getBoolean("hibernate.transaction.flush_before_completion", properties);
        log.info("Automatic flush during beforeCompletion(): " + SettingsFactory.enabledDisabled(flushBeforeCompletion));
        settings.setFlushBeforeCompletionEnabled(flushBeforeCompletion);
        boolean autoCloseSession = PropertiesHelper.getBoolean("hibernate.transaction.auto_close_session", properties);
        log.info("Automatic session close at end of transaction: " + SettingsFactory.enabledDisabled(autoCloseSession));
        settings.setAutoCloseSessionEnabled(autoCloseSession);
        int batchSize = PropertiesHelper.getInt("hibernate.jdbc.batch_size", properties, 0);
        if (!metaSupportsBatchUpdates) {
            batchSize = 0;
        }
        if (batchSize > 0) {
            log.info("JDBC batch size: " + batchSize);
        }
        settings.setJdbcBatchSize(batchSize);
        boolean jdbcBatchVersionedData = PropertiesHelper.getBoolean("hibernate.jdbc.batch_versioned_data", properties, false);
        if (batchSize > 0) {
            log.info("JDBC batch updates for versioned data: " + SettingsFactory.enabledDisabled(jdbcBatchVersionedData));
        }
        settings.setJdbcBatchVersionedData(jdbcBatchVersionedData);
        settings.setBatcherFactory(this.createBatcherFactory(properties, batchSize));
        boolean useScrollableResultSets = PropertiesHelper.getBoolean("hibernate.jdbc.use_scrollable_resultset", properties, metaSupportsScrollable);
        log.info("Scrollable result sets: " + SettingsFactory.enabledDisabled(useScrollableResultSets));
        settings.setScrollableResultSetsEnabled(useScrollableResultSets);
        boolean wrapResultSets = PropertiesHelper.getBoolean("hibernate.jdbc.wrap_result_sets", properties, false);
        log.debug("Wrap result sets: " + SettingsFactory.enabledDisabled(wrapResultSets));
        settings.setWrapResultSetsEnabled(wrapResultSets);
        boolean useGetGeneratedKeys = PropertiesHelper.getBoolean("hibernate.jdbc.use_get_generated_keys", properties, metaSupportsGetGeneratedKeys);
        log.info("JDBC3 getGeneratedKeys(): " + SettingsFactory.enabledDisabled(useGetGeneratedKeys));
        settings.setGetGeneratedKeysEnabled(useGetGeneratedKeys);
        Integer statementFetchSize = PropertiesHelper.getInteger("hibernate.jdbc.fetch_size", properties);
        if (statementFetchSize != null) {
            log.info("JDBC result set fetch size: " + statementFetchSize);
        }
        settings.setJdbcFetchSize(statementFetchSize);
        String releaseModeName = PropertiesHelper.getString("hibernate.connection.release_mode", properties, "auto");
        log.info("Connection release mode: " + releaseModeName);
        if ("auto".equals(releaseModeName)) {
            releaseMode = transactionFactory.getDefaultReleaseMode();
        } else {
            releaseMode = ConnectionReleaseMode.parse(releaseModeName);
            if (releaseMode == ConnectionReleaseMode.AFTER_STATEMENT && !connections.supportsAggressiveRelease()) {
                log.warn("Overriding release mode as connection provider does not support 'after_statement'");
                releaseMode = ConnectionReleaseMode.AFTER_TRANSACTION;
            }
        }
        settings.setConnectionReleaseMode(releaseMode);
        String defaultSchema = properties.getProperty("hibernate.default_schema");
        String defaultCatalog = properties.getProperty("hibernate.default_catalog");
        if (defaultSchema != null) {
            log.info("Default schema: " + defaultSchema);
        }
        if (defaultCatalog != null) {
            log.info("Default catalog: " + defaultCatalog);
        }
        settings.setDefaultSchemaName(defaultSchema);
        settings.setDefaultCatalogName(defaultCatalog);
        Integer maxFetchDepth = PropertiesHelper.getInteger("hibernate.max_fetch_depth", properties);
        if (maxFetchDepth != null) {
            log.info("Maximum outer join fetch depth: " + maxFetchDepth);
        }
        settings.setMaximumFetchDepth(maxFetchDepth);
        int batchFetchSize = PropertiesHelper.getInt("hibernate.default_batch_fetch_size", properties, 1);
        log.info("Default batch fetch size: " + batchFetchSize);
        settings.setDefaultBatchFetchSize(batchFetchSize);
        boolean comments = PropertiesHelper.getBoolean("hibernate.use_sql_comments", properties);
        log.info("Generate SQL with comments: " + SettingsFactory.enabledDisabled(comments));
        settings.setCommentsEnabled(comments);
        boolean orderUpdates = PropertiesHelper.getBoolean("hibernate.order_updates", properties);
        log.info("Order SQL updates by primary key: " + SettingsFactory.enabledDisabled(orderUpdates));
        settings.setOrderUpdatesEnabled(orderUpdates);
        boolean orderInserts = PropertiesHelper.getBoolean("hibernate.order_inserts", properties);
        log.info("Order SQL inserts for batching: " + SettingsFactory.enabledDisabled(orderInserts));
        settings.setOrderInsertsEnabled(orderInserts);
        settings.setQueryTranslatorFactory(this.createQueryTranslatorFactory(properties));
        Map querySubstitutions = PropertiesHelper.toMap("hibernate.query.substitutions", " ,=;:\n\t\r\f", properties);
        log.info("Query language substitutions: " + querySubstitutions);
        settings.setQuerySubstitutions(querySubstitutions);
        boolean jpaqlCompliance = PropertiesHelper.getBoolean("hibernate.query.jpaql_strict_compliance", properties, false);
        settings.setStrictJPAQLCompliance(jpaqlCompliance);
        log.info("JPA-QL strict compliance: " + SettingsFactory.enabledDisabled(jpaqlCompliance));
        boolean useSecondLevelCache = PropertiesHelper.getBoolean("hibernate.cache.use_second_level_cache", properties, true);
        log.info("Second-level cache: " + SettingsFactory.enabledDisabled(useSecondLevelCache));
        settings.setSecondLevelCacheEnabled(useSecondLevelCache);
        boolean useQueryCache = PropertiesHelper.getBoolean("hibernate.cache.use_query_cache", properties);
        log.info("Query cache: " + SettingsFactory.enabledDisabled(useQueryCache));
        settings.setQueryCacheEnabled(useQueryCache);
        settings.setRegionFactory(SettingsFactory.createRegionFactory(properties, useSecondLevelCache || useQueryCache));
        boolean useMinimalPuts = PropertiesHelper.getBoolean("hibernate.cache.use_minimal_puts", properties, settings.getRegionFactory().isMinimalPutsEnabledByDefault());
        log.info("Optimize cache for minimal puts: " + SettingsFactory.enabledDisabled(useMinimalPuts));
        settings.setMinimalPutsEnabled(useMinimalPuts);
        String prefix = properties.getProperty("hibernate.cache.region_prefix");
        if (StringHelper.isEmpty(prefix)) {
            prefix = null;
        }
        if (prefix != null) {
            log.info("Cache region prefix: " + prefix);
        }
        settings.setCacheRegionPrefix(prefix);
        boolean useStructuredCacheEntries = PropertiesHelper.getBoolean("hibernate.cache.use_structured_entries", properties, false);
        log.info("Structured second-level cache entries: " + SettingsFactory.enabledDisabled(useStructuredCacheEntries));
        settings.setStructuredCacheEntriesEnabled(useStructuredCacheEntries);
        if (useQueryCache) {
            settings.setQueryCacheFactory(this.createQueryCacheFactory(properties));
        }
        try {
            sqlExceptionConverter = SQLExceptionConverterFactory.buildSQLExceptionConverter(dialect, properties);
        }
        catch (HibernateException e) {
            log.warn("Error building SQLExceptionConverter; using minimal converter");
            sqlExceptionConverter = SQLExceptionConverterFactory.buildMinimalSQLExceptionConverter();
        }
        settings.setSQLExceptionConverter(sqlExceptionConverter);
        boolean showSql = PropertiesHelper.getBoolean("hibernate.show_sql", properties);
        if (showSql) {
            log.info("Echoing all SQL to stdout");
        }
        boolean formatSql = PropertiesHelper.getBoolean("hibernate.format_sql", properties);
        settings.setSqlStatementLogger(new SQLStatementLogger(showSql, formatSql));
        boolean useStatistics = PropertiesHelper.getBoolean("hibernate.generate_statistics", properties);
        log.info("Statistics: " + SettingsFactory.enabledDisabled(useStatistics));
        settings.setStatisticsEnabled(useStatistics);
        boolean useIdentifierRollback = PropertiesHelper.getBoolean("hibernate.use_identifier_rollback", properties);
        log.info("Deleted entity synthetic identifier rollback: " + SettingsFactory.enabledDisabled(useIdentifierRollback));
        settings.setIdentifierRollbackEnabled(useIdentifierRollback);
        String autoSchemaExport = properties.getProperty("hibernate.hbm2ddl.auto");
        if ("validate".equals(autoSchemaExport)) {
            settings.setAutoValidateSchema(true);
        }
        if ("update".equals(autoSchemaExport)) {
            settings.setAutoUpdateSchema(true);
        }
        if ("create".equals(autoSchemaExport)) {
            settings.setAutoCreateSchema(true);
        }
        if ("create-drop".equals(autoSchemaExport)) {
            settings.setAutoCreateSchema(true);
            settings.setAutoDropSchema(true);
        }
        settings.setImportFiles(properties.getProperty("hibernate.hbm2ddl.import_files"));
        EntityMode defaultEntityMode = EntityMode.parse(properties.getProperty("hibernate.default_entity_mode"));
        log.info("Default entity-mode: " + defaultEntityMode);
        settings.setDefaultEntityMode(defaultEntityMode);
        boolean namedQueryChecking = PropertiesHelper.getBoolean("hibernate.query.startup_check", properties, true);
        log.info("Named query checking : " + SettingsFactory.enabledDisabled(namedQueryChecking));
        settings.setNamedQueryStartupCheckingEnabled(namedQueryChecking);
        boolean checkNullability = PropertiesHelper.getBoolean("hibernate.check_nullability", properties, true);
        log.info("Check Nullability in Core (should be disabled when Bean Validation is on): " + SettingsFactory.enabledDisabled(checkNullability));
        settings.setCheckNullability(checkNullability);
        return settings;
    }

    protected BytecodeProvider buildBytecodeProvider(String providerName) {
        if ("javassist".equals(providerName)) {
            return new org.hibernate.bytecode.javassist.BytecodeProviderImpl();
        }
        if ("cglib".equals(providerName)) {
            return new BytecodeProviderImpl();
        }
        log.debug("using cglib as bytecode provider by default");
        return new BytecodeProviderImpl();
    }

    private static String enabledDisabled(boolean value) {
        return value ? "enabled" : "disabled";
    }

    protected QueryCacheFactory createQueryCacheFactory(Properties properties) {
        String queryCacheFactoryClassName = PropertiesHelper.getString("hibernate.cache.query_cache_factory", properties, "org.hibernate.cache.StandardQueryCacheFactory");
        log.info("Query cache factory: " + queryCacheFactoryClassName);
        try {
            return (QueryCacheFactory)ReflectHelper.classForName(queryCacheFactoryClassName).newInstance();
        }
        catch (Exception cnfe) {
            throw new HibernateException("could not instantiate QueryCacheFactory: " + queryCacheFactoryClassName, cnfe);
        }
    }

    public static RegionFactory createRegionFactory(Properties properties, boolean cachingEnabled) {
        String providerClassName;
        String regionFactoryClassName = PropertiesHelper.getString("hibernate.cache.region.factory_class", properties, null);
        if (regionFactoryClassName == null && cachingEnabled && (providerClassName = PropertiesHelper.getString("hibernate.cache.provider_class", properties, null)) != null) {
            regionFactoryClassName = RegionFactoryCacheProviderBridge.class.getName();
        }
        if (regionFactoryClassName == null) {
            regionFactoryClassName = DEF_CACHE_REG_FACTORY;
        }
        log.info("Cache region factory : " + regionFactoryClassName);
        try {
            return (RegionFactory)ReflectHelper.classForName(regionFactoryClassName).getConstructor(Properties.class).newInstance(properties);
        }
        catch (Exception e) {
            throw new HibernateException("could not instantiate RegionFactory [" + regionFactoryClassName + "]", e);
        }
    }

    protected QueryTranslatorFactory createQueryTranslatorFactory(Properties properties) {
        String className = PropertiesHelper.getString("hibernate.query.factory_class", properties, "org.hibernate.hql.ast.ASTQueryTranslatorFactory");
        log.info("Query translator: " + className);
        try {
            return (QueryTranslatorFactory)ReflectHelper.classForName(className).newInstance();
        }
        catch (Exception cnfe) {
            throw new HibernateException("could not instantiate QueryTranslatorFactory: " + className, cnfe);
        }
    }

    protected BatcherFactory createBatcherFactory(Properties properties, int batchSize) {
        String batcherClass = properties.getProperty("hibernate.jdbc.factory_class");
        if (batcherClass == null) {
            return batchSize == 0 ? new NonBatchingBatcherFactory() : new BatchingBatcherFactory();
        }
        log.info("Batcher factory: " + batcherClass);
        try {
            return (BatcherFactory)ReflectHelper.classForName(batcherClass).newInstance();
        }
        catch (Exception cnfe) {
            throw new HibernateException("could not instantiate BatcherFactory: " + batcherClass, cnfe);
        }
    }

    protected ConnectionProvider createConnectionProvider(Properties properties) {
        return ConnectionProviderFactory.newConnectionProvider(properties);
    }

    protected TransactionFactory createTransactionFactory(Properties properties) {
        return TransactionFactoryFactory.buildTransactionFactory(properties);
    }

    protected TransactionManagerLookup createTransactionManagerLookup(Properties properties) {
        return TransactionManagerLookupFactory.getTransactionManagerLookup(properties);
    }
}

