/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine;

import java.io.InvalidObjectException;
import java.io.ObjectStreamException;
import java.io.Serializable;

public final class Status
implements Serializable {
    public static final Status MANAGED = new Status("MANAGED");
    public static final Status READ_ONLY = new Status("READ_ONLY");
    public static final Status DELETED = new Status("DELETED");
    public static final Status GONE = new Status("GONE");
    public static final Status LOADING = new Status("LOADING");
    public static final Status SAVING = new Status("SAVING");
    private String name;

    private Status(String name) {
        this.name = name;
    }

    public String toString() {
        return this.name;
    }

    private Object readResolve() throws ObjectStreamException {
        return Status.parse(this.name);
    }

    public static Status parse(String name) throws InvalidObjectException {
        if (name.equals(Status.MANAGED.name)) {
            return MANAGED;
        }
        if (name.equals(Status.READ_ONLY.name)) {
            return READ_ONLY;
        }
        if (name.equals(Status.DELETED.name)) {
            return DELETED;
        }
        if (name.equals(Status.GONE.name)) {
            return GONE;
        }
        if (name.equals(Status.LOADING.name)) {
            return LOADING;
        }
        if (name.equals(Status.SAVING.name)) {
            return SAVING;
        }
        throw new InvalidObjectException("invalid Status");
    }
}

