/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.reflect.hosted;

import com.oracle.svm.core.annotate.AutomaticFeature;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.util.GuardedAnnotationAccess;
import sun.reflect.generics.repository.ClassRepository;
import sun.reflect.generics.repository.ConstructorRepository;
import sun.reflect.generics.repository.FieldRepository;
import sun.reflect.generics.repository.GenericDeclRepository;
import sun.reflect.generics.repository.MethodRepository;

@AutomaticFeature
public class ReflectionMetadataFeature
implements Feature {
    public void duringSetup(Feature.DuringSetupAccess access) {
        access.registerObjectReplacer(ReflectionMetadataFeature::replacer);
    }

    private static Object replacer(Object original) {
        GenericDeclRepository methodRepository;
        if (original instanceof Method) {
            Method method = (Method)original;
            method.getGenericReturnType();
        }
        if (original instanceof Executable) {
            Executable executable = (Executable)original;
            executable.getGenericParameterTypes();
            executable.getGenericExceptionTypes();
            executable.getParameters();
            executable.getTypeParameters();
        }
        if (original instanceof Field) {
            Field field = (Field)original;
            field.getGenericType();
        }
        if (original instanceof AccessibleObject) {
            AccessibleObject accessibleObject = (AccessibleObject)original;
            GuardedAnnotationAccess.getDeclaredAnnotations((AnnotatedElement)accessibleObject);
        }
        if (original instanceof Parameter) {
            Parameter parameter = (Parameter)original;
            parameter.getType();
        }
        if (original instanceof FieldRepository) {
            FieldRepository fieldRepository = (FieldRepository)original;
            fieldRepository.getGenericType();
        }
        if (original instanceof MethodRepository) {
            methodRepository = (MethodRepository)original;
            ((MethodRepository)methodRepository).getReturnType();
        }
        if (original instanceof ConstructorRepository) {
            ConstructorRepository constructorRepository = (ConstructorRepository)original;
            constructorRepository.getExceptionTypes();
            constructorRepository.getParameterTypes();
        }
        if (original instanceof GenericDeclRepository) {
            methodRepository = (GenericDeclRepository)original;
            methodRepository.getTypeParameters();
        }
        if (original instanceof ClassRepository) {
            ClassRepository classRepository = (ClassRepository)original;
            classRepository.getSuperclass();
            classRepository.getSuperInterfaces();
        }
        return original;
    }
}

