/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.methodhandles;

import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.annotate.AnnotateOriginal;
import com.oracle.svm.core.annotate.Delete;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.annotate.TargetElement;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.jdk.JDK11OrLater;
import com.oracle.svm.core.jdk.JDK8OrEarlier;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.methodhandles.MethodHandleIntrinsic;
import com.oracle.svm.methodhandles.MethodHandlesSupported;
import com.oracle.svm.methodhandles.Target_java_lang_invoke_MemberName;
import com.oracle.svm.methodhandles.Target_java_lang_invoke_MethodHandleNatives_CallSiteContext;
import com.oracle.svm.methodhandles.Target_java_lang_invoke_MethodHandleNatives_Constants;
import com.oracle.svm.methodhandles.Util_java_lang_invoke_MethodHandleNatives;
import com.oracle.svm.reflect.target.Target_java_lang_reflect_Field;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.graalvm.compiler.serviceprovider.GraalUnsafeAccess;

@TargetClass(className="java.lang.invoke.MethodHandleNatives", onlyWith={MethodHandlesSupported.class})
final class Target_java_lang_invoke_MethodHandleNatives {
    Target_java_lang_invoke_MethodHandleNatives() {
    }

    @Substitute
    private static void init(Target_java_lang_invoke_MemberName self, Object ref) {
        byte refKind;
        int flags;
        Object[] type;
        Member member = (Member)ref;
        if (member instanceof Field) {
            Field field = (Field)member;
            type = field.getType();
            flags = Target_java_lang_invoke_MethodHandleNatives_Constants.MN_IS_FIELD | field.getModifiers();
            refKind = Modifier.isStatic(field.getModifiers()) ? Target_java_lang_invoke_MethodHandleNatives_Constants.REF_getStatic : Target_java_lang_invoke_MethodHandleNatives_Constants.REF_getField;
        } else if (member instanceof Method) {
            Method method = (Method)member;
            Object[] typeInfo = new Object[]{method.getReturnType(), method.getParameterTypes()};
            type = typeInfo;
            int mods = method.getModifiers();
            flags = Target_java_lang_invoke_MethodHandleNatives_Constants.MN_IS_METHOD | mods;
            refKind = Modifier.isStatic(mods) ? Target_java_lang_invoke_MethodHandleNatives_Constants.REF_invokeStatic : (Modifier.isInterface(mods) ? Target_java_lang_invoke_MethodHandleNatives_Constants.REF_invokeInterface : Target_java_lang_invoke_MethodHandleNatives_Constants.REF_invokeVirtual);
        } else if (member instanceof Constructor) {
            Constructor constructor = (Constructor)member;
            Object[] typeInfo = new Object[]{Void.TYPE, constructor.getParameterTypes()};
            type = typeInfo;
            flags = Target_java_lang_invoke_MethodHandleNatives_Constants.MN_IS_CONSTRUCTOR | constructor.getModifiers();
            refKind = Target_java_lang_invoke_MethodHandleNatives_Constants.REF_newInvokeSpecial;
        } else {
            throw new InternalError("unknown member type: " + member.getClass());
        }
        self.init(member.getDeclaringClass(), member.getName(), type, flags |= refKind << Target_java_lang_invoke_MethodHandleNatives_Constants.MN_REFERENCE_KIND_SHIFT);
        self.reflectAccess = (Member)ref;
    }

    @Substitute
    private static void expand(Target_java_lang_invoke_MemberName self) {
        throw VMError.unsupportedFeature("MethodHandleNatives.expand()");
    }

    @Delete
    private static native int getMembers(Class<?> var0, String var1, String var2, int var3, Class<?> var4, int var5, Target_java_lang_invoke_MemberName[] var6);

    @Substitute
    private static long objectFieldOffset(Target_java_lang_invoke_MemberName self) {
        if (self.reflectAccess == null && self.intrinsic == null) {
            throw new InternalError("unresolved field");
        }
        if (!self.isField() || self.isStatic()) {
            throw new InternalError("non-static field required");
        }
        if (self.intrinsic != null) {
            return -1L;
        }
        return GraalUnsafeAccess.getUnsafe().objectFieldOffset((Field)self.reflectAccess);
    }

    @Substitute
    private static long staticFieldOffset(Target_java_lang_invoke_MemberName self) {
        if (!self.isField() || !self.isStatic()) {
            throw new InternalError("static field required");
        }
        return 0L;
    }

    @Substitute
    private static Object staticFieldBase(Target_java_lang_invoke_MemberName self) {
        if (self.reflectAccess == null) {
            throw new InternalError("unresolved field");
        }
        if (!self.isField() || !self.isStatic()) {
            throw new InternalError("static field required");
        }
        return SubstrateUtil.cast(self.reflectAccess, Target_java_lang_reflect_Field.class).acquireFieldAccessor(false);
    }

    @Substitute
    private static Object getMemberVMInfo(Target_java_lang_invoke_MemberName self) {
        throw VMError.unsupportedFeature("MethodHandleNatives.getMemberVMInfo()");
    }

    @Delete
    private static native void setCallSiteTargetNormal(CallSite var0, MethodHandle var1);

    @Delete
    private static native void setCallSiteTargetVolatile(CallSite var0, MethodHandle var1);

    @Delete
    private static native void registerNatives();

    @Delete
    private static native int getNamedCon(int var0, Object[] var1);

    @Delete
    @TargetElement(onlyWith={JDK8OrEarlier.class})
    private static native Target_java_lang_invoke_MemberName resolve(Target_java_lang_invoke_MemberName var0, Class<?> var1) throws LinkageError, ClassNotFoundException;

    @Delete
    @TargetElement(onlyWith={JDK8OrEarlier.class})
    private static native int getConstant(int var0);

    @TargetElement(onlyWith={JDK11OrLater.class})
    @Substitute
    static Target_java_lang_invoke_MemberName resolve(Target_java_lang_invoke_MemberName self, Class<?> caller, boolean speculativeResolve) throws LinkageError, ClassNotFoundException {
        if (self.reflectAccess != null) {
            return self;
        }
        Class<?> declaringClass = self.getDeclaringClass();
        if (declaringClass == null) {
            return null;
        }
        self.intrinsic = MethodHandleIntrinsic.resolve(self);
        if (self.intrinsic != null) {
            self.flags |= self.intrinsic.variant.flags;
            return self;
        }
        try {
            if (self.isMethod()) {
                Class<?>[] parameterTypes = self.getMethodType().parameterArray();
                Method method = Util_java_lang_invoke_MethodHandleNatives.lookupMethod(declaringClass, self.name, parameterTypes);
                if (method.getReturnType() != self.getMethodType().returnType()) {
                    throw new NoSuchMethodException(SubstrateUtil.cast(declaringClass, DynamicHub.class).methodToString(self.name, parameterTypes));
                }
                self.reflectAccess = method;
                self.flags |= method.getModifiers();
            } else if (self.isConstructor()) {
                Constructor<?> constructor;
                self.reflectAccess = constructor = declaringClass.getDeclaredConstructor(self.getMethodType().parameterArray());
                self.flags |= constructor.getModifiers();
            } else if (self.isField()) {
                Field field = Util_java_lang_invoke_MethodHandleNatives.lookupField(declaringClass, self.name);
                if (field.getType() != self.getFieldType()) {
                    throw new NoSuchFieldException(declaringClass.getName() + "." + self.name);
                }
                self.reflectAccess = field;
                self.flags |= field.getModifiers();
            }
            return self;
        }
        catch (NoSuchMethodException e) {
            if (speculativeResolve) {
                return null;
            }
            throw new NoSuchMethodError(e.getMessage());
        }
        catch (NoSuchFieldException e) {
            if (speculativeResolve) {
                return null;
            }
            throw new NoSuchFieldError(e.getMessage());
        }
    }

    @Delete
    @TargetElement(onlyWith={JDK11OrLater.class})
    private static native void copyOutBootstrapArguments(Class<?> var0, int[] var1, int var2, int var3, Object[] var4, int var5, boolean var6, Object var7);

    @Substitute
    @TargetElement(onlyWith={JDK11OrLater.class})
    private static void clearCallSiteContext(Target_java_lang_invoke_MethodHandleNatives_CallSiteContext context) {
        throw VMError.unimplemented("CallSiteContext not supported");
    }

    @AnnotateOriginal
    static native boolean refKindIsMethod(byte var0);

    @AnnotateOriginal
    static native String refKindName(byte var0);
}

