/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.snippets;

import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.graal.GraalFeature;
import com.oracle.svm.core.graal.meta.RuntimeConfiguration;
import com.oracle.svm.core.graal.meta.SubstrateForeignCallsProvider;
import com.oracle.svm.core.snippets.ExceptionUnwind;
import com.oracle.svm.core.snippets.ImplicitExceptions;
import com.oracle.svm.core.snippets.SnippetRuntime;
import com.oracle.svm.hosted.FeatureImpl;
import jdk.vm.ci.meta.MetaAccessProvider;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticFeature
final class ImplicitExceptionsFeature
implements GraalFeature {
    ImplicitExceptionsFeature() {
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess a) {
        FeatureImpl.BeforeAnalysisAccessImpl access = (FeatureImpl.BeforeAnalysisAccessImpl)a;
        for (SnippetRuntime.SubstrateForeignCallDescriptor descriptor : ImplicitExceptions.FOREIGN_CALLS) {
            access.getBigBang().addRootMethod((AnalysisMethod)descriptor.findMethod((MetaAccessProvider)access.getMetaAccess()));
        }
        for (SnippetRuntime.SubstrateForeignCallDescriptor descriptor : ExceptionUnwind.FOREIGN_CALLS) {
            access.getBigBang().addRootMethod((AnalysisMethod)descriptor.findMethod((MetaAccessProvider)access.getMetaAccess()));
        }
    }

    @Override
    public void registerForeignCalls(RuntimeConfiguration runtimeConfig, Providers providers, SnippetReflectionProvider snippetReflection, SubstrateForeignCallsProvider foreignCalls, boolean hosted) {
        foreignCalls.register(providers, ImplicitExceptions.FOREIGN_CALLS);
        foreignCalls.register(providers, ExceptionUnwind.FOREIGN_CALLS);
    }
}

