/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.phases;

import com.oracle.svm.core.graal.snippets.DeoptHostedSnippets;
import com.oracle.svm.hosted.meta.HostedMethod;
import com.oracle.svm.hosted.nodes.SubstrateMethodCallTargetNode;
import jdk.vm.ci.meta.DeoptimizationAction;
import jdk.vm.ci.meta.DeoptimizationReason;
import jdk.vm.ci.meta.JavaMethodProfile;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.SpeculationLog;
import org.graalvm.compiler.core.common.type.ObjectStamp;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.core.common.type.TypeReference;
import org.graalvm.compiler.graph.Graph;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.CallTargetNode;
import org.graalvm.compiler.nodes.FixedGuardNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.Invoke;
import org.graalvm.compiler.nodes.LogicConstantNode;
import org.graalvm.compiler.nodes.LogicNode;
import org.graalvm.compiler.nodes.PiNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.extended.ValueAnchorNode;
import org.graalvm.compiler.phases.Phase;
import org.graalvm.compiler.phases.common.inlining.InliningUtil;

public class DevirtualizeCallsPhase
extends Phase {
    protected void run(StructuredGraph graph) {
        for (Invoke invoke : graph.getInvokes()) {
            if (!(invoke.callTarget() instanceof SubstrateMethodCallTargetNode)) continue;
            SubstrateMethodCallTargetNode callTarget = (SubstrateMethodCallTargetNode)invoke.callTarget();
            if (callTarget.invokeKind().isDirect() && !((HostedMethod)callTarget.targetMethod()).getWrapped().isSimplyImplementationInvoked()) {
                DevirtualizeCallsPhase.unreachableInvoke(graph, invoke, callTarget);
                continue;
            }
            JavaMethodProfile methodProfile = callTarget.getMethodProfile();
            if (methodProfile == null) continue;
            if (methodProfile.getMethods().length == 0) {
                DevirtualizeCallsPhase.unreachableInvoke(graph, invoke, callTarget);
                continue;
            }
            if (methodProfile.getMethods().length != 1 || !callTarget.invokeKind().isIndirect()) continue;
            DevirtualizeCallsPhase.singleCallee((HostedMethod)methodProfile.getMethods()[0].getMethod(), graph, invoke, callTarget);
        }
    }

    private static void unreachableInvoke(StructuredGraph graph, Invoke invoke, SubstrateMethodCallTargetNode callTarget) {
        if (!callTarget.isStatic()) {
            InliningUtil.nonNullReceiver((Invoke)invoke);
        }
        DeoptHostedSnippets.AnalysisSpeculation speculation = new DeoptHostedSnippets.AnalysisSpeculation(new DeoptHostedSnippets.AnalysisSpeculationReason("The call to " + callTarget.targetMethod().format("%H.%n(%P)") + " is not reachable."));
        FixedGuardNode node = new FixedGuardNode((LogicNode)LogicConstantNode.forBoolean((boolean)true, (Graph)graph), DeoptimizationReason.UnreachedCode, DeoptimizationAction.None, (SpeculationLog.Speculation)speculation, true);
        graph.addBeforeFixed(invoke.asNode(), (FixedWithNextNode)graph.add((Node)node));
        graph.getDebug().dump(5, (Object)graph, "After dead invoke %s", (Object)invoke);
    }

    private static void singleCallee(HostedMethod singleCallee, StructuredGraph graph, Invoke invoke, SubstrateMethodCallTargetNode callTarget) {
        ValueAnchorNode anchor = (ValueAnchorNode)graph.add((Node)new ValueAnchorNode(null));
        graph.addBeforeFixed(invoke.asNode(), (FixedWithNextNode)anchor);
        ObjectStamp anchoredReceiverStamp = StampFactory.object((TypeReference)TypeReference.createWithoutAssumptions((ResolvedJavaType)singleCallee.getDeclaringClass()));
        ValueNode anchoredReceiver = (ValueNode)graph.unique((Node)new PiNode(invoke.getReceiver(), (Stamp)anchoredReceiverStamp, (ValueNode)anchor));
        invoke.callTarget().replaceFirstInput((Node)invoke.getReceiver(), (Node)anchoredReceiver);
        assert (callTarget.invokeKind() == CallTargetNode.InvokeKind.Virtual || callTarget.invokeKind() == CallTargetNode.InvokeKind.Interface);
        callTarget.setInvokeKind(CallTargetNode.InvokeKind.Special);
        callTarget.setTargetMethod(singleCallee);
    }
}

