/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.code;

import com.oracle.graal.pointsto.infrastructure.GraphProvider;
import com.oracle.graal.pointsto.infrastructure.SubstitutionProcessor;
import com.oracle.graal.pointsto.infrastructure.WrappedJavaMethod;
import java.lang.annotation.Annotation;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.spi.Replacements;
import org.graalvm.compiler.word.Word;
import org.graalvm.nativeimage.c.constant.CConstant;
import org.graalvm.nativeimage.c.function.CFunction;

public class NativeMethodSubstitutionProcessor
extends SubstitutionProcessor {
    private static final Class<?>[] FILTER_ANNOTATIONS = new Class[]{Node.NodeIntrinsic.class, Word.Operation.class, CConstant.class};
    private final SubstitutionProcessor processor;
    private final Replacements replacements;

    public NativeMethodSubstitutionProcessor(SubstitutionProcessor processor, Replacements replacements) {
        this.processor = processor;
        this.replacements = replacements;
    }

    public ResolvedJavaMethod lookup(ResolvedJavaMethod method) {
        boolean isHandledByPlugin;
        if (!method.isNative()) {
            return method;
        }
        if (method.getCodeSize() != 0 || method instanceof GraphProvider) {
            assert (!(method instanceof WrappedJavaMethod)) : "Must not see AnalysisMethod or HostedMethod here";
            return method;
        }
        for (Annotation annotation : method.getAnnotations()) {
            for (Class<?> c : FILTER_ANNOTATIONS) {
                if (annotation.annotationType() != c) continue;
                return method;
            }
            assert (annotation.annotationType() != CFunction.class) : "CFunction must have been handled by another SubstitutionProcessor";
        }
        boolean bl = isHandledByPlugin = this.replacements.getGraphBuilderPlugins().getInvocationPlugins().lookupInvocation(method) != null;
        if (isHandledByPlugin) {
            return method;
        }
        return this.processor.lookup(method);
    }

    public ResolvedJavaMethod resolve(ResolvedJavaMethod method) {
        return this.processor.resolve(method);
    }
}

