/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.agent.jdk8.lambda;

import jdk.internal.org.objectweb.asm.MethodVisitor;
import jdk.internal.org.objectweb.asm.Type;
import sun.invoke.util.BytecodeDescriptor;
import sun.invoke.util.Wrapper;

class TypeConvertingMethodAdapter
extends MethodVisitor {
    private static final int NUM_WRAPPERS = Wrapper.values().length;
    private static final String NAME_OBJECT = "java/lang/Object";
    private static final String WRAPPER_PREFIX = "Ljava/lang/";
    private static final String NAME_BOX_METHOD = "valueOf";
    private static final int[][] wideningOpcodes = new int[NUM_WRAPPERS][NUM_WRAPPERS];
    private static final Wrapper[] FROM_WRAPPER_NAME = new Wrapper[16];
    private static final Wrapper[] FROM_TYPE_SORT = new Wrapper[16];

    TypeConvertingMethodAdapter(MethodVisitor mv) {
        super(327680, mv);
    }

    private static void initWidening(Wrapper to, int opcode, Wrapper ... from) {
        for (Wrapper f : from) {
            TypeConvertingMethodAdapter.wideningOpcodes[f.ordinal()][to.ordinal()] = opcode;
        }
    }

    private static int hashWrapperName(String xn) {
        if (xn.length() < 3) {
            return 0;
        }
        return (3 * xn.charAt(1) + xn.charAt(2)) % 16;
    }

    private static Wrapper wrapperOrNullFromDescriptor(String desc) {
        if (!desc.startsWith(WRAPPER_PREFIX)) {
            return null;
        }
        String cname = desc.substring(WRAPPER_PREFIX.length(), desc.length() - 1);
        Wrapper w = FROM_WRAPPER_NAME[TypeConvertingMethodAdapter.hashWrapperName(cname)];
        if (w == null || w.wrapperSimpleName().equals(cname)) {
            return w;
        }
        return null;
    }

    private static String wrapperName(Wrapper w) {
        return "java/lang/" + w.wrapperSimpleName();
    }

    private static String unboxMethod(Wrapper w) {
        return w.primitiveSimpleName() + "Value";
    }

    private static String boxingDescriptor(Wrapper w) {
        return String.format("(%s)L%s;", Character.valueOf(w.basicTypeChar()), TypeConvertingMethodAdapter.wrapperName(w));
    }

    private static String unboxingDescriptor(Wrapper w) {
        return "()" + w.basicTypeChar();
    }

    void boxIfTypePrimitive(Type t) {
        Wrapper w = FROM_TYPE_SORT[t.getSort()];
        if (w != null) {
            this.box(w);
        }
    }

    void widen(Wrapper ws, Wrapper wt) {
        int opcode;
        if (ws != wt && (opcode = wideningOpcodes[ws.ordinal()][wt.ordinal()]) != 0) {
            this.visitInsn(opcode);
        }
    }

    void box(Wrapper w) {
        this.visitMethodInsn(184, TypeConvertingMethodAdapter.wrapperName(w), NAME_BOX_METHOD, TypeConvertingMethodAdapter.boxingDescriptor(w), false);
    }

    void unbox(String sname, Wrapper wt) {
        this.visitMethodInsn(182, sname, TypeConvertingMethodAdapter.unboxMethod(wt), TypeConvertingMethodAdapter.unboxingDescriptor(wt), false);
    }

    private static String descriptorToName(String desc) {
        int last = desc.length() - 1;
        if (desc.charAt(0) == 'L' && desc.charAt(last) == ';') {
            return desc.substring(1, last);
        }
        return desc;
    }

    void cast(String ds, String dt) {
        String ns = TypeConvertingMethodAdapter.descriptorToName(ds);
        String nt = TypeConvertingMethodAdapter.descriptorToName(dt);
        if (!nt.equals(ns) && !nt.equals(NAME_OBJECT)) {
            this.visitTypeInsn(192, nt);
        }
    }

    private static Wrapper toWrapper(String desc) {
        char first = desc.charAt(0);
        if (first == '[' || first == '(') {
            first = 'L';
        }
        return Wrapper.forBasicType(first);
    }

    void convertType(Class<?> arg, Class<?> target, Class<?> functional) {
        if (arg.equals(target) && arg.equals(functional)) {
            return;
        }
        if (arg == Void.TYPE || target == Void.TYPE) {
            return;
        }
        if (arg.isPrimitive()) {
            Wrapper wArg = Wrapper.forPrimitiveType(arg);
            if (target.isPrimitive()) {
                this.widen(wArg, Wrapper.forPrimitiveType(target));
            } else {
                String dTarget = BytecodeDescriptor.unparse(target);
                Wrapper wPrimTarget = TypeConvertingMethodAdapter.wrapperOrNullFromDescriptor(dTarget);
                if (wPrimTarget != null) {
                    this.widen(wArg, wPrimTarget);
                    this.box(wPrimTarget);
                } else {
                    this.box(wArg);
                    this.cast(TypeConvertingMethodAdapter.wrapperName(wArg), dTarget);
                }
            }
        } else {
            String dSrc;
            String dArg = BytecodeDescriptor.unparse(arg);
            if (functional.isPrimitive()) {
                dSrc = dArg;
            } else {
                dSrc = BytecodeDescriptor.unparse(functional);
                this.cast(dArg, dSrc);
            }
            String dTarget = BytecodeDescriptor.unparse(target);
            if (target.isPrimitive()) {
                Wrapper wTarget = TypeConvertingMethodAdapter.toWrapper(dTarget);
                Wrapper wps = TypeConvertingMethodAdapter.wrapperOrNullFromDescriptor(dSrc);
                if (wps != null) {
                    if (wps.isSigned() || wps.isFloating()) {
                        this.unbox(TypeConvertingMethodAdapter.wrapperName(wps), wTarget);
                    } else {
                        this.unbox(TypeConvertingMethodAdapter.wrapperName(wps), wps);
                        this.widen(wps, wTarget);
                    }
                } else {
                    String intermediate = wTarget.isSigned() || wTarget.isFloating() ? "java/lang/Number" : TypeConvertingMethodAdapter.wrapperName(wTarget);
                    this.cast(dSrc, intermediate);
                    this.unbox(intermediate, wTarget);
                }
            } else {
                this.cast(dSrc, dTarget);
            }
        }
    }

    void iconst(int cst) {
        if (cst >= -1 && cst <= 5) {
            this.mv.visitInsn(3 + cst);
        } else if (cst >= -128 && cst <= 127) {
            this.mv.visitIntInsn(16, cst);
        } else if (cst >= Short.MIN_VALUE && cst <= Short.MAX_VALUE) {
            this.mv.visitIntInsn(17, cst);
        } else {
            this.mv.visitLdcInsn(cst);
        }
    }

    static {
        for (Wrapper w : Wrapper.values()) {
            if (w.basicTypeChar() == 'L') continue;
            int wi = TypeConvertingMethodAdapter.hashWrapperName(w.wrapperSimpleName());
            assert (FROM_WRAPPER_NAME[wi] == null);
            TypeConvertingMethodAdapter.FROM_WRAPPER_NAME[wi] = w;
        }
        for (int i = 0; i < NUM_WRAPPERS; ++i) {
            for (int j = 0; j < NUM_WRAPPERS; ++j) {
                TypeConvertingMethodAdapter.wideningOpcodes[i][j] = 0;
            }
        }
        TypeConvertingMethodAdapter.initWidening(Wrapper.LONG, 133, Wrapper.BYTE, Wrapper.SHORT, Wrapper.INT, Wrapper.CHAR);
        TypeConvertingMethodAdapter.initWidening(Wrapper.LONG, 140, Wrapper.FLOAT);
        TypeConvertingMethodAdapter.initWidening(Wrapper.FLOAT, 134, Wrapper.BYTE, Wrapper.SHORT, Wrapper.INT, Wrapper.CHAR);
        TypeConvertingMethodAdapter.initWidening(Wrapper.FLOAT, 137, Wrapper.LONG);
        TypeConvertingMethodAdapter.initWidening(Wrapper.DOUBLE, 135, Wrapper.BYTE, Wrapper.SHORT, Wrapper.INT, Wrapper.CHAR);
        TypeConvertingMethodAdapter.initWidening(Wrapper.DOUBLE, 141, Wrapper.FLOAT);
        TypeConvertingMethodAdapter.initWidening(Wrapper.DOUBLE, 138, Wrapper.LONG);
        TypeConvertingMethodAdapter.FROM_TYPE_SORT[3] = Wrapper.BYTE;
        TypeConvertingMethodAdapter.FROM_TYPE_SORT[4] = Wrapper.SHORT;
        TypeConvertingMethodAdapter.FROM_TYPE_SORT[5] = Wrapper.INT;
        TypeConvertingMethodAdapter.FROM_TYPE_SORT[7] = Wrapper.LONG;
        TypeConvertingMethodAdapter.FROM_TYPE_SORT[2] = Wrapper.CHAR;
        TypeConvertingMethodAdapter.FROM_TYPE_SORT[6] = Wrapper.FLOAT;
        TypeConvertingMethodAdapter.FROM_TYPE_SORT[8] = Wrapper.DOUBLE;
        TypeConvertingMethodAdapter.FROM_TYPE_SORT[1] = Wrapper.BOOLEAN;
    }
}

