/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.meta;

import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.deopt.Deoptimizer;
import java.lang.reflect.AnnotatedElement;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.nativeimage.c.function.CFunction;
import org.graalvm.nativeimage.c.function.InvokeCFunctionPointer;
import org.graalvm.util.DirectAnnotationAccess;

public interface SharedMethod
extends ResolvedJavaMethod {
    public boolean isEntryPoint();

    public boolean hasCalleeSavedRegisters();

    public SharedMethod[] getImplementations();

    public boolean isDeoptTarget();

    public boolean canDeoptimize();

    public int getVTableIndex();

    public Deoptimizer.StubType getDeoptStubType();

    public int getCodeOffsetInImage();

    public int getDeoptOffsetInImage();

    default public boolean isUninterruptible() {
        if (DirectAnnotationAccess.isAnnotationPresent((AnnotatedElement)((Object)this), Uninterruptible.class)) {
            return true;
        }
        CFunction cFunctionAnnotation = (CFunction)DirectAnnotationAccess.getAnnotation((AnnotatedElement)((Object)this), CFunction.class);
        InvokeCFunctionPointer cFunctionPointerAnnotation = (InvokeCFunctionPointer)DirectAnnotationAccess.getAnnotation((AnnotatedElement)((Object)this), InvokeCFunctionPointer.class);
        if (cFunctionAnnotation != null && cFunctionAnnotation.transition() == CFunction.Transition.NO_TRANSITION || cFunctionPointerAnnotation != null && cFunctionPointerAnnotation.transition() == CFunction.Transition.NO_TRANSITION) {
            return true;
        }
        return this.isEntryPoint();
    }
}

