/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.configuration.resolvers;

import java.util.Optional;
import org.flywaydb.core.ProgressLogger;
import org.flywaydb.core.api.CoreErrorCode;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.internal.configuration.resolvers.PropertyResolver;
import org.flywaydb.core.internal.configuration.resolvers.PropertyResolverContext;

public class PlaceholderPropertyResolver
implements PropertyResolver {
    @Override
    public String getName() {
        return "placeholder";
    }

    @Override
    public String resolve(String key, PropertyResolverContext context, ProgressLogger progress) {
        if ("flyway".equals(key)) {
            throw new FlywayException("Only user defined placeholders are supported, but detected attempt to use a default placeholder.", CoreErrorCode.CONFIGURATION);
        }
        return Optional.ofNullable(context.getConfiguration().getPlaceholders()).map(placeholders -> (String)placeholders.get(key)).orElseThrow(() -> new FlywayException("Unable to resolve placeholder: '" + key + "'", CoreErrorCode.CONFIGURATION));
    }

    @Override
    public Class<?> getConfigClass() {
        return null;
    }
}

