/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.resolver;

import de.pdark.decentxml.Document;
import de.pdark.decentxml.Element;
import de.pdark.decentxml.XMLIOSource;
import de.pdark.decentxml.XMLParseException;
import de.pdark.decentxml.XMLParser;
import de.pdark.decentxml.XMLSource;
import de.pdark.decentxml.XMLWriter;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.codehaus.plexus.util.IOUtil;
import org.eclipse.tycho.core.resolver.shared.IncludeSourceMode;
import org.eclipse.tycho.p2.target.facade.TargetDefinition;
import org.eclipse.tycho.p2.target.facade.TargetDefinitionSyntaxException;

public final class TargetDefinitionFile
implements TargetDefinition {
    private static XMLParser parser = new XMLParser();
    private final File origin;
    private final byte[] fileContentHash;
    private final Element dom;
    private final Document document;
    final IncludeSourceMode includeSourceMode;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TargetDefinitionFile(File source, IncludeSourceMode includeSourceMode) throws TargetDefinitionSyntaxException {
        try {
            this.origin = source;
            this.fileContentHash = TargetDefinitionFile.computeFileContentHash(source);
            this.includeSourceMode = includeSourceMode;
            FileInputStream input = new FileInputStream(source);
            try {
                this.document = parser.parse((XMLSource)new XMLIOSource(source));
                this.dom = this.document.getRootElement();
            }
            finally {
                input.close();
            }
        }
        catch (XMLParseException e) {
            throw new TargetDefinitionSyntaxException("Target definition is not well-formed XML: " + e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            throw new TargetDefinitionSyntaxException("I/O error while reading target definition file: " + e.getMessage(), (Throwable)e);
        }
    }

    public List<? extends TargetDefinition.Location> getLocations() {
        ArrayList<Object> locations = new ArrayList<Object>();
        Element locationsDom = this.dom.getChild("locations");
        if (locationsDom != null) {
            for (Element locationDom : locationsDom.getChildren("location")) {
                String type = locationDom.getAttributeValue("type");
                if ("InstallableUnit".equals(type)) {
                    locations.add(new IULocation(locationDom));
                    continue;
                }
                locations.add(new OtherLocation(type));
            }
        }
        return Collections.unmodifiableList(locations);
    }

    public boolean hasIncludedBundles() {
        return this.dom.getChild("includeBundles") != null;
    }

    public String getOrigin() {
        return this.origin.getAbsolutePath();
    }

    public static TargetDefinitionFile read(File file, IncludeSourceMode includeSourceMode) {
        try {
            return new TargetDefinitionFile(file, includeSourceMode);
        }
        catch (TargetDefinitionSyntaxException e) {
            throw new RuntimeException("Invalid syntax in target definition " + file + ": " + e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(TargetDefinitionFile target, File file) throws IOException {
        BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(file));
        Document document = target.document;
        try {
            String enc = document.getEncoding() != null ? document.getEncoding() : "UTF-8";
            OutputStreamWriter w = new OutputStreamWriter((OutputStream)os, enc);
            XMLWriter xw = new XMLWriter((Writer)w);
            try {
                document.toXML(xw);
            }
            finally {
                xw.flush();
            }
        }
        finally {
            IOUtil.close((OutputStream)os);
        }
    }

    public int hashCode() {
        return Arrays.hashCode(this.fileContentHash);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TargetDefinitionFile)) {
            return false;
        }
        TargetDefinitionFile other = (TargetDefinitionFile)obj;
        return Arrays.equals(this.fileContentHash, other.fileContentHash);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] computeFileContentHash(File source) {
        byte[] digest;
        try {
            FileInputStream in = new FileInputStream(source);
            try {
                digest = TargetDefinitionFile.computeMD5Digest(in);
            }
            finally {
                in.close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException("I/O error while reading \"" + source + "\": " + e.getMessage(), e);
        }
        return digest;
    }

    private static byte[] computeMD5Digest(FileInputStream in) throws IOException {
        MessageDigest digest = TargetDefinitionFile.newMD5Digest();
        byte[] buffer = new byte[4096];
        while (in.read(buffer) > 0) {
            digest.update(buffer);
        }
        return digest.digest();
    }

    private static MessageDigest newMD5Digest() {
        try {
            return MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static class Unit
    implements TargetDefinition.Unit {
        private final Element dom;

        public Unit(Element dom) {
            this.dom = dom;
        }

        public String getId() {
            return this.dom.getAttributeValue("id");
        }

        public String getVersion() {
            return this.dom.getAttributeValue("version");
        }

        @Deprecated
        public void setVersion(String version) {
            this.dom.setAttribute("version", version);
        }
    }

    public static final class Repository
    implements TargetDefinition.Repository {
        private final Element dom;

        public Repository(Element dom) {
            this.dom = dom;
        }

        public String getId() {
            return this.dom.getAttributeValue("id");
        }

        public URI getLocation() {
            try {
                return new URI(this.dom.getAttributeValue("location"));
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }

        @Deprecated
        public void setLocation(String location) {
            this.dom.setAttribute("location", location);
        }
    }

    public static class OtherLocation
    implements TargetDefinition.Location {
        private final String description;

        public OtherLocation(String description) {
            this.description = description;
        }

        public String getTypeDescription() {
            return this.description;
        }
    }

    public class IULocation
    implements TargetDefinition.InstallableUnitLocation {
        private final Element dom;

        public IULocation(Element dom) {
            this.dom = dom;
        }

        public List<? extends TargetDefinition.Unit> getUnits() {
            ArrayList<Unit> units = new ArrayList<Unit>();
            for (Element unitDom : this.dom.getChildren("unit")) {
                units.add(new Unit(unitDom));
            }
            return Collections.unmodifiableList(units);
        }

        public List<? extends TargetDefinition.Repository> getRepositories() {
            return this.getRepositoryImpls();
        }

        public List<Repository> getRepositoryImpls() {
            List repositoryNodes = this.dom.getChildren("repository");
            ArrayList<Repository> repositories = new ArrayList<Repository>(repositoryNodes.size());
            for (Element node : repositoryNodes) {
                repositories.add(new Repository(node));
            }
            return repositories;
        }

        public String getTypeDescription() {
            return this.dom.getAttributeValue("type");
        }

        public TargetDefinition.IncludeMode getIncludeMode() {
            String attributeValue = this.dom.getAttributeValue("includeMode");
            if ("slicer".equals(attributeValue)) {
                return TargetDefinition.IncludeMode.SLICER;
            }
            if ("planner".equals(attributeValue) || attributeValue == null) {
                return TargetDefinition.IncludeMode.PLANNER;
            }
            throw new TargetDefinitionSyntaxException("Invalid value for attribute 'includeMode': " + attributeValue + "");
        }

        public boolean includeAllEnvironments() {
            return Boolean.parseBoolean(this.dom.getAttributeValue("includeAllPlatforms"));
        }

        public boolean includeSource() {
            switch (TargetDefinitionFile.this.includeSourceMode) {
                case ignore: {
                    return false;
                }
                case force: {
                    return true;
                }
            }
            return Boolean.parseBoolean(this.dom.getAttributeValue("includeSource"));
        }
    }
}

