/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packager.rpm.signature;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.bouncycastle.bcpg.ArmoredInputStream;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.bc.BcPGPSecretKeyRing;
import org.bouncycastle.openpgp.operator.PGPDigestCalculatorProvider;
import org.bouncycastle.openpgp.operator.bc.BcPBESecretKeyDecryptorBuilder;
import org.bouncycastle.openpgp.operator.bc.BcPGPDigestCalculatorProvider;
import org.eclipse.packager.rpm.HashAlgorithm;
import org.eclipse.packager.rpm.RpmSignatureTag;
import org.eclipse.packager.rpm.Rpms;
import org.eclipse.packager.rpm.header.Header;
import org.eclipse.packager.rpm.header.Headers;
import org.eclipse.packager.rpm.info.RpmInformation;
import org.eclipse.packager.rpm.info.RpmInformations;
import org.eclipse.packager.rpm.parse.RpmInputStream;
import org.eclipse.packager.rpm.signature.RsaSignatureProcessor;
import org.eclipse.packager.rpm.signature.SignatureProcessor;
import org.eclipse.packager.rpm.signature.SignatureProcessors;

public class RpmFileSignatureProcessor {
    private RpmFileSignatureProcessor() {
    }

    public static void perform(Path rpm, InputStream privateKeyIn, String passphrase, OutputStream out, HashAlgorithm hashAlgorithm) throws IOException, PGPException {
        byte[] signatureHeader;
        long archiveSize;
        long payloadStart;
        long payloadHeaderLength;
        long payloadHeaderStart;
        long signatureHeaderLength;
        long signatureHeaderStart;
        long leadLength = 96L;
        if (!Files.exists(rpm, new LinkOption[0])) {
            throw new IOException("The file " + String.valueOf(rpm.getFileName()) + " does not exist");
        }
        PGPPrivateKey privateKey = RpmFileSignatureProcessor.getPrivateKey(privateKeyIn, passphrase);
        try (RpmInputStream rpmIn = new RpmInputStream(new BufferedInputStream(Files.newInputStream(rpm, new OpenOption[0])));){
            signatureHeaderStart = rpmIn.getSignatureHeader().getStart();
            signatureHeaderLength = rpmIn.getSignatureHeader().getLength();
            payloadHeaderStart = rpmIn.getPayloadHeader().getStart();
            payloadHeaderLength = rpmIn.getPayloadHeader().getLength();
            RpmInformation info = RpmInformations.makeInformation(rpmIn);
            payloadStart = info.getHeaderEnd();
            archiveSize = info.getArchiveSize();
        }
        if (signatureHeaderStart == 0L || signatureHeaderLength == 0L || payloadHeaderStart == 0L || payloadHeaderLength == 0L || payloadStart == 0L || archiveSize == 0L) {
            throw new IOException("Unable to read " + String.valueOf(rpm.getFileName()) + " informations.");
        }
        try (FileChannel channelIn = FileChannel.open(rpm, new OpenOption[0]);){
            long payloadSize = channelIn.size() - payloadStart;
            channelIn.position(96L + signatureHeaderLength);
            ByteBuffer payloadHeaderBuff = ByteBuffer.allocate((int)payloadHeaderLength);
            IOUtils.readFully((ReadableByteChannel)channelIn, (ByteBuffer)payloadHeaderBuff);
            ByteBuffer payloadBuff = ByteBuffer.allocate((int)payloadSize);
            IOUtils.readFully((ReadableByteChannel)channelIn, (ByteBuffer)payloadBuff);
            signatureHeader = RpmFileSignatureProcessor.getSignature(privateKey, payloadHeaderBuff, payloadBuff, archiveSize, hashAlgorithm);
        }
        try (InputStream in = Files.newInputStream(rpm, new OpenOption[0]);){
            IOUtils.copyLarge((InputStream)in, (OutputStream)out, (long)0L, (long)96L);
            IOUtils.skip((InputStream)in, (long)signatureHeaderLength);
            out.write(signatureHeader);
            IOUtils.copy((InputStream)in, (OutputStream)out);
        }
    }

    private static byte[] getSignature(PGPPrivateKey privateKey, ByteBuffer payloadHeader, ByteBuffer payload, long archiveSize, HashAlgorithm hashAlgorithm) throws IOException {
        Header<RpmSignatureTag> signatureHeader = new Header<RpmSignatureTag>();
        List<SignatureProcessor> signatureProcessors = RpmFileSignatureProcessor.getSignatureProcessors(privateKey, hashAlgorithm);
        payloadHeader.flip();
        payload.flip();
        for (SignatureProcessor processor : signatureProcessors) {
            processor.init(archiveSize);
            processor.feedHeader(payloadHeader.slice());
            processor.feedPayloadData(payload.slice());
            processor.finish(signatureHeader);
        }
        ByteBuffer signatureBuf = Headers.render(signatureHeader.makeEntries(), true, 62);
        int payloadSize = signatureBuf.remaining();
        int padding = Rpms.padding(payloadSize);
        byte[] signature = RpmFileSignatureProcessor.safeReadBuffer(signatureBuf);
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        result.write(signature);
        if (padding > 0) {
            result.write(RpmFileSignatureProcessor.safeReadBuffer(ByteBuffer.wrap(Rpms.EMPTY_128, 0, padding)));
        }
        return result.toByteArray();
    }

    private static byte[] safeReadBuffer(ByteBuffer buf) throws IOException {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        while (buf.hasRemaining()) {
            result.write(buf.get());
        }
        return result.toByteArray();
    }

    private static List<SignatureProcessor> getSignatureProcessors(PGPPrivateKey privateKey, HashAlgorithm hashAlgorithm) {
        ArrayList<SignatureProcessor> signatureProcessors = new ArrayList<SignatureProcessor>();
        signatureProcessors.add(SignatureProcessors.size());
        signatureProcessors.add(SignatureProcessors.sha256Header());
        signatureProcessors.add(SignatureProcessors.sha1Header());
        signatureProcessors.add(SignatureProcessors.md5());
        signatureProcessors.add(SignatureProcessors.payloadSize());
        signatureProcessors.add(new RsaSignatureProcessor(privateKey, hashAlgorithm));
        return signatureProcessors;
    }

    private static PGPPrivateKey getPrivateKey(InputStream privateKeyIn, String passphrase) throws PGPException, IOException {
        ArmoredInputStream armor = new ArmoredInputStream(privateKeyIn);
        BcPGPSecretKeyRing secretKeyRing = new BcPGPSecretKeyRing((InputStream)armor);
        PGPSecretKey secretKey = secretKeyRing.getSecretKey();
        return secretKey.extractPrivateKey(new BcPBESecretKeyDecryptorBuilder((PGPDigestCalculatorProvider)new BcPGPDigestCalculatorProvider()).build(passphrase.toCharArray()));
    }
}

