/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packager.rpm.header;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Objects;
import org.eclipse.packager.rpm.Rpms;
import org.eclipse.packager.rpm.header.HeaderEntry;
import org.eclipse.packager.rpm.header.Type;

public final class Headers {
    private Headers() {
    }

    public static ByteBuffer render(HeaderEntry[] entries, boolean sorted, Integer immutableTag) throws IOException {
        Objects.requireNonNull(entries);
        if (sorted) {
            Arrays.sort(entries, Comparator.comparingInt(HeaderEntry::getTag));
        }
        int numEntries = entries.length;
        if (immutableTag != null) {
            ++numEntries;
        }
        int len = 16;
        int entriesLen = numEntries * 4 * 4;
        len += entriesLen;
        len += Arrays.stream(entries).mapToInt(Headers::rawEntrySize).sum();
        if (immutableTag != null) {
            len += 16;
        }
        ByteBuffer buffer = ByteBuffer.allocate(len += numEntries * 8);
        buffer.put(Rpms.HEADER_MAGIC);
        buffer.put((byte)1);
        buffer.put(Rpms.EMPTY_128, 0, 4);
        buffer.putInt(numEntries);
        int payloadSizePosition = buffer.position();
        buffer.putInt(0);
        buffer.position(buffer.position() + entriesLen);
        int startPayloadPosition = buffer.position();
        int i = immutableTag == null ? 0 : 1;
        for (HeaderEntry entry : entries) {
            Headers.align(buffer, entry);
            int index = buffer.position() - startPayloadPosition;
            buffer.put(entry.getData());
            Headers.fillEntryRecord(buffer, i, entry, index);
            ++i;
        }
        if (immutableTag != null) {
            ByteBuffer tagData = ByteBuffer.wrap(new byte[16]);
            int numImmutable = entries.length + 1;
            Headers.fillEntryRecordAt(tagData, 0, immutableTag, Type.BLOB.type(), -numImmutable * 16, 16);
            int index = buffer.position() - startPayloadPosition;
            buffer.put(tagData.array());
            Headers.fillEntryRecord(buffer, 0, immutableTag, Type.BLOB.type(), index, 16);
        }
        int payloadSize = buffer.position() - startPayloadPosition;
        buffer.putInt(payloadSizePosition, payloadSize);
        buffer.flip();
        return buffer;
    }

    private static void fillEntryRecord(ByteBuffer buffer, int entryIndex, HeaderEntry entry, int index) {
        Headers.fillEntryRecord(buffer, entryIndex, entry.getTag(), entry.getType().type(), index, entry.getCount());
    }

    private static void fillEntryRecord(ByteBuffer buffer, int entryIndex, int tag, int type, int index, int count) {
        int entryPosition = 16 + entryIndex * 16;
        Headers.fillEntryRecordAt(buffer, entryPosition, tag, type, index, count);
    }

    private static void fillEntryRecordAt(ByteBuffer buffer, int position, int tag, int type, int index, int count) {
        buffer.putInt(position, tag);
        buffer.putInt(position + 4, type);
        buffer.putInt(position + 8, index);
        buffer.putInt(position + 12, count);
    }

    public static byte[] makeEntryRecord(int tag, int type, int index, int count) {
        ByteBuffer buffer = ByteBuffer.wrap(new byte[16]);
        Headers.fillEntryRecordAt(buffer, 0, tag, type, index, count);
        return buffer.array();
    }

    private static void align(ByteBuffer buffer, HeaderEntry entry) {
        int alignment;
        int position = buffer.position();
        int v = position % (alignment = entry.getType().align());
        if (v <= 0) {
            return;
        }
        int len = alignment - v;
        buffer.put(Rpms.EMPTY_128, 0, len);
    }

    private static int rawEntrySize(HeaderEntry entry) {
        return entry.getData() != null ? entry.getData().length : 0;
    }
}

