/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.metrics;

import java.util.Objects;
import org.eclipse.microprofile.metrics.DefaultMetadata;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.MetricType;

public class MetadataBuilder {
    private String name;
    private String displayName;
    private String description;
    private MetricType type;
    private String unit;

    MetadataBuilder(Metadata metadata) {
        this.name = metadata.getName();
        this.type = metadata.getTypeRaw();
        metadata.description().ifPresent(this::withDescription);
        metadata.unit().ifPresent(this::withUnit);
        metadata.displayName().ifPresent(this::withDisplayName);
    }

    public MetadataBuilder() {
    }

    public MetadataBuilder withName(String name) {
        this.name = Objects.requireNonNull(name, "name is required");
        if ("".equals(name)) {
            throw new IllegalArgumentException("Name must not be empty");
        }
        return this;
    }

    public MetadataBuilder withDisplayName(String displayName) {
        this.displayName = "".equals(displayName) ? null : displayName;
        return this;
    }

    public MetadataBuilder withDescription(String description) {
        this.description = "".equals(description) ? null : description;
        return this;
    }

    public MetadataBuilder withType(MetricType type) {
        this.type = MetricType.INVALID == type ? null : type;
        return this;
    }

    public MetadataBuilder withUnit(String unit) {
        this.unit = "none".equals(unit) ? null : unit;
        return this;
    }

    public Metadata build() {
        if (Objects.isNull(this.name)) {
            throw new IllegalStateException("Name is required");
        }
        return new DefaultMetadata(this.name, this.displayName, this.description, this.type, this.unit);
    }
}

