/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.log;

import java.util.logging.Level;
import org.eclipse.jetty.util.log.Logger;

public class JavaUtilLog
implements Logger {
    private java.util.logging.Logger _logger;

    public JavaUtilLog() {
        this("org.eclipse.jetty.util.log");
    }

    public JavaUtilLog(String name) {
        this._logger = java.util.logging.Logger.getLogger(name);
        if (Boolean.getBoolean("org.eclipse.jetty.util.log.DEBUG")) {
            this._logger.setLevel(Level.FINE);
        }
    }

    @Override
    public String getName() {
        return this._logger.getName();
    }

    @Override
    public void debug(String msg) {
        this._logger.log(Level.FINE, msg);
    }

    @Override
    public void debug(String msg, Throwable th) {
        this._logger.log(Level.FINE, msg, th);
    }

    @Override
    public void debug(String msg, Object arg0, Object arg1) {
        this._logger.log(Level.FINE, this.format(msg, arg0, arg1));
    }

    @Override
    public Logger getLogger(String name) {
        return new JavaUtilLog(name);
    }

    @Override
    public void info(String msg) {
        this._logger.log(Level.INFO, msg);
    }

    @Override
    public void info(String msg, Object arg0, Object arg1) {
        this._logger.log(Level.INFO, this.format(msg, arg0, arg1));
    }

    @Override
    public boolean isDebugEnabled() {
        return this._logger.isLoggable(Level.FINE);
    }

    @Override
    public void setDebugEnabled(boolean enabled) {
        this._logger.setLevel(Level.FINE);
    }

    @Override
    public void warn(String msg) {
        this._logger.log(Level.WARNING, msg);
    }

    @Override
    public void warn(String msg, Object arg0, Object arg1) {
        this._logger.log(Level.WARNING, this.format(msg, arg0, arg1));
    }

    @Override
    public void warn(String msg, Throwable th) {
        this._logger.log(Level.WARNING, msg, th);
    }

    private String format(String msg, Object arg0, Object arg1) {
        int i1;
        int i0 = msg.indexOf("{}");
        int n = i1 = i0 < 0 ? -1 : msg.indexOf("{}", i0 + 2);
        if (arg1 != null && i1 >= 0) {
            msg = msg.substring(0, i1) + arg1 + msg.substring(i1 + 2);
        }
        if (arg0 != null && i0 >= 0) {
            msg = msg.substring(0, i0) + arg0 + msg.substring(i0 + 2);
        }
        return msg;
    }
}

