/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.start;

import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import org.eclipse.jetty.start.Config;

public class Monitor
extends Thread {
    private int _port;
    private String _key;
    ServerSocket _socket;

    Monitor(int port, String key) {
        this._port = port;
        this._key = key;
        try {
            if (this._port < 0) {
                return;
            }
            this.setDaemon(true);
            this.setName("StopMonitor");
            this._socket = new ServerSocket(this._port, 1, InetAddress.getByName("127.0.0.1"));
            if (this._port == 0) {
                this._port = this._socket.getLocalPort();
                System.out.println(this._port);
            }
            if (this._key == null) {
                this._key = Long.toString((long)(9.223372036854776E18 * Math.random() + (double)this.hashCode() + (double)System.currentTimeMillis()), 36);
                System.out.println("STOP.KEY=" + this._key);
            }
        }
        catch (Exception e) {
            Config.debug(e);
            System.err.println(e.toString());
        }
        if (this._socket != null) {
            this.start();
        } else {
            System.err.println("WARN: Not listening on monitor port: " + this._port);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (true) {
            Socket socket = null;
            try {
                socket = this._socket.accept();
                LineNumberReader lin = new LineNumberReader(new InputStreamReader(socket.getInputStream()));
                String key = lin.readLine();
                if (!this._key.equals(key)) continue;
                String cmd = lin.readLine();
                Config.debug("command=" + cmd);
                if ("stop".equals(cmd)) {
                    try {
                        socket.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    try {
                        this._socket.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    System.exit(0);
                    continue;
                }
                if (!"status".equals(cmd)) continue;
                socket.getOutputStream().write("OK\r\n".getBytes());
                socket.getOutputStream().flush();
                continue;
            }
            catch (Exception e) {
                Config.debug(e);
                System.err.println(e.toString());
                continue;
            }
            finally {
                if (socket != null) {
                    try {
                        socket.close();
                    }
                    catch (Exception exception) {}
                }
                socket = null;
                continue;
            }
            break;
        }
    }

    public static void monitor(int port, String key) {
        new Monitor(port, key);
    }
}

