/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.maven.plugin;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.eclipse.jetty.maven.plugin.AbstractJettyMojo;
import org.eclipse.jetty.util.Scanner;

public class JettyRunWarExplodedMojo
extends AbstractJettyMojo {
    private File war;

    public void execute() throws MojoExecutionException, MojoFailureException {
        super.execute();
    }

    public void checkPomConfiguration() throws MojoExecutionException {
    }

    public void configureScanner() throws MojoExecutionException {
        File jettyEnvXmlFile;
        this.scanList = new ArrayList();
        this.scanList.add(this.project.getFile());
        File webInfDir = new File(this.war, "WEB-INF");
        this.scanList.add(new File(webInfDir, "web.xml"));
        File jettyWebXmlFile = this.findJettyWebXmlFile(webInfDir);
        if (jettyWebXmlFile != null) {
            this.scanList.add(jettyWebXmlFile);
        }
        if ((jettyEnvXmlFile = new File(webInfDir, "jetty-env.xml")).exists()) {
            this.scanList.add(jettyEnvXmlFile);
        }
        this.scanList.add(new File(webInfDir, "classes"));
        this.scanList.add(new File(webInfDir, "lib"));
        this.scannerListeners = new ArrayList();
        this.scannerListeners.add(new Scanner.BulkListener(){

            public void filesChanged(List changes) {
                try {
                    boolean reconfigure = changes.contains(JettyRunWarExplodedMojo.this.project.getFile().getCanonicalPath());
                    JettyRunWarExplodedMojo.this.restartWebApp(reconfigure);
                }
                catch (Exception e) {
                    JettyRunWarExplodedMojo.this.getLog().error((CharSequence)"Error reconfiguring/restarting webapp after change in watched files", (Throwable)e);
                }
            }
        });
    }

    public void restartWebApp(boolean reconfigureScanner) throws Exception {
        this.getLog().info((CharSequence)"Restarting webapp");
        this.getLog().debug((CharSequence)"Stopping webapp ...");
        this.webApp.stop();
        this.getLog().debug((CharSequence)"Reconfiguring webapp ...");
        this.checkPomConfiguration();
        if (reconfigureScanner) {
            File jettyEnvXmlFile;
            this.getLog().info((CharSequence)"Reconfiguring scanner after change to pom.xml ...");
            this.scanList.clear();
            this.scanList.add(this.project.getFile());
            File webInfDir = new File(this.war, "WEB-INF");
            this.scanList.add(new File(webInfDir, "web.xml"));
            File jettyWebXmlFile = this.findJettyWebXmlFile(webInfDir);
            if (jettyWebXmlFile != null) {
                this.scanList.add(jettyWebXmlFile);
            }
            if ((jettyEnvXmlFile = new File(webInfDir, "jetty-env.xml")).exists()) {
                this.scanList.add(jettyEnvXmlFile);
            }
            this.scanList.add(new File(webInfDir, "classes"));
            this.scanList.add(new File(webInfDir, "lib"));
            this.scanner.setScanDirs((List)this.scanList);
        }
        this.getLog().debug((CharSequence)"Restarting webapp ...");
        this.webApp.start();
        this.getLog().info((CharSequence)"Restart completed.");
    }

    public void configureWebApplication() throws Exception {
        super.configureWebApplication();
        this.webApp.setWar(this.war.getCanonicalPath());
    }
}

