/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.annotations;

import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.annotation.HandlesTypes;
import org.eclipse.jetty.annotations.AbstractConfiguration;
import org.eclipse.jetty.annotations.AnnotationParser;
import org.eclipse.jetty.annotations.ClassInheritanceHandler;
import org.eclipse.jetty.annotations.ContainerInitializerAnnotationHandler;
import org.eclipse.jetty.annotations.WebAppDecoratorWrapper;
import org.eclipse.jetty.annotations.WebFilterAnnotationHandler;
import org.eclipse.jetty.annotations.WebListenerAnnotationHandler;
import org.eclipse.jetty.annotations.WebServletAnnotationHandler;
import org.eclipse.jetty.plus.annotation.ContainerInitializer;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.webapp.WebAppContext;

public class AnnotationConfiguration
extends AbstractConfiguration {
    public static final String CLASS_INHERITANCE_MAP = "org.eclipse.jetty.classInheritanceMap";

    public void preConfigure(WebAppContext context) throws Exception {
    }

    public void configure(WebAppContext context) throws Exception {
        Boolean b = (Boolean)context.getAttribute("org.eclipse.jetty.metadataComplete");
        boolean metadataComplete = b != null && b != false;
        WebAppDecoratorWrapper wrapper = new WebAppDecoratorWrapper(context, context.getDecorator());
        context.setDecorator((ServletContextHandler.Decorator)wrapper);
        if (metadataComplete) {
            if (Log.isDebugEnabled()) {
                Log.debug((String)("Metadata-complete==true,  not processing annotations for context " + context));
            }
            return;
        }
        if (Log.isDebugEnabled()) {
            Log.debug((String)"parsing annotations");
        }
        AnnotationParser parser = new AnnotationParser();
        parser.registerAnnotationHandler("javax.servlet.annotation.WebServlet", new WebServletAnnotationHandler(context));
        parser.registerAnnotationHandler("javax.servlet.annotation.WebFilter", new WebFilterAnnotationHandler(context));
        parser.registerAnnotationHandler("javax.servlet.annotation.WebListener", new WebListenerAnnotationHandler(context));
        ClassInheritanceHandler classHandler = new ClassInheritanceHandler();
        parser.registerClassHandler(classHandler);
        this.registerServletContainerInitializerAnnotationHandlers(context, parser);
        if (context.getServletContext().getEffectiveMajorVersion() >= 3 || context.isConfigurationDiscovered()) {
            if (Log.isDebugEnabled()) {
                Log.debug((String)("Scanning all classses for annotations: webxmlVersion=" + context.getServletContext().getEffectiveMajorVersion() + " configurationDiscovered=" + context.isConfigurationDiscovered()));
            }
            this.parseContainerPath(context, parser);
            this.parseWebInfLib(context, parser);
            this.parseWebInfClasses(context, parser);
        } else {
            if (Log.isDebugEnabled()) {
                Log.debug((String)"Scanning only classes in web.xml for annotations");
            }
            this.parse25Classes(context, parser);
        }
        context.setAttribute(CLASS_INHERITANCE_MAP, (Object)classHandler.getMap());
    }

    public void deconfigure(WebAppContext context) throws Exception {
    }

    public void postConfigure(WebAppContext context) throws Exception {
    }

    public void registerServletContainerInitializerAnnotationHandlers(WebAppContext context, AnnotationParser parser) {
        ArrayList<ContainerInitializer> initializers = new ArrayList<ContainerInitializer>();
        context.setAttribute("org.eclipse.jetty.containerInitializers", initializers);
        ServiceLoader<ServletContainerInitializer> loadedInitializers = ServiceLoader.load(ServletContainerInitializer.class, context.getClassLoader());
        List orderedJars = (List)context.getAttribute("javax.servlet.context.orderedLibs");
        if (loadedInitializers != null) {
            for (ServletContainerInitializer service : loadedInitializers) {
                if (this.isFromExcludedJar(context, orderedJars, service)) continue;
                HandlesTypes annotation = service.getClass().getAnnotation(HandlesTypes.class);
                ContainerInitializer initializer = new ContainerInitializer();
                initializer.setTarget(service);
                initializers.add(initializer);
                if (annotation != null) {
                    Class[] classes = annotation.value();
                    if (classes != null) {
                        initializer.setInterestedTypes(classes);
                        for (Class c : classes) {
                            if (!c.isAnnotation()) continue;
                            if (Log.isDebugEnabled()) {
                                Log.debug((String)("Registering annotation handler for " + c.getName()));
                            }
                            parser.registerAnnotationHandler(c.getName(), new ContainerInitializerAnnotationHandler(initializer, c));
                        }
                        continue;
                    }
                    Log.info((String)("No classes in HandlesTypes on initializer " + service.getClass()));
                    continue;
                }
                Log.info((String)("No annotation on initializer " + service.getClass()));
            }
        }
    }

    public boolean isFromExcludedJar(WebAppContext context, List<String> orderedJars, ServletContainerInitializer service) {
        boolean isExcluded = false;
        try {
            String loadingJarName = Thread.currentThread().getContextClassLoader().getResource(service.getClass().getName().replace('.', '/') + ".class").toString();
            int i = loadingJarName.indexOf(".jar");
            int j = loadingJarName.lastIndexOf("/", i);
            loadingJarName = loadingJarName.substring(j + 1, i + 4);
            if (orderedJars != null) {
                isExcluded = orderedJars.contains(loadingJarName);
            }
        }
        catch (Exception e) {
            Log.warn((String)("Problem determining jar containing ServletContaininerInitializer " + service), (Throwable)e);
        }
        return isExcluded;
    }
}

