/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.zoo.model;

import java.io.IOException;
import java.util.Arrays;
import org.deeplearning4j.common.resources.DL4JResources;
import org.deeplearning4j.nn.api.Model;
import org.deeplearning4j.nn.api.OptimizationAlgorithm;
import org.deeplearning4j.nn.conf.CacheMode;
import org.deeplearning4j.nn.conf.ComputationGraphConfiguration;
import org.deeplearning4j.nn.conf.ConvolutionMode;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.conf.WorkspaceMode;
import org.deeplearning4j.nn.conf.graph.GraphVertex;
import org.deeplearning4j.nn.conf.graph.MergeVertex;
import org.deeplearning4j.nn.conf.inputs.InputType;
import org.deeplearning4j.nn.conf.layers.ActivationLayer;
import org.deeplearning4j.nn.conf.layers.ConvolutionLayer;
import org.deeplearning4j.nn.conf.layers.DropoutLayer;
import org.deeplearning4j.nn.conf.layers.GlobalPoolingLayer;
import org.deeplearning4j.nn.conf.layers.Layer;
import org.deeplearning4j.nn.conf.layers.LossLayer;
import org.deeplearning4j.nn.conf.layers.PoolingType;
import org.deeplearning4j.nn.conf.layers.SubsamplingLayer;
import org.deeplearning4j.nn.graph.ComputationGraph;
import org.deeplearning4j.nn.weights.WeightInit;
import org.deeplearning4j.zoo.ModelMetaData;
import org.deeplearning4j.zoo.PretrainedType;
import org.deeplearning4j.zoo.ZooModel;
import org.deeplearning4j.zoo.ZooType;
import org.nd4j.linalg.activations.Activation;
import org.nd4j.linalg.learning.config.AdaDelta;
import org.nd4j.linalg.learning.config.IUpdater;
import org.nd4j.linalg.lossfunctions.LossFunctions;

public class SqueezeNet
extends ZooModel {
    private long seed;
    private int[] inputShape;
    private int numClasses;
    private WeightInit weightInit;
    private IUpdater updater;
    private CacheMode cacheMode;
    private WorkspaceMode workspaceMode;
    private ConvolutionLayer.AlgoMode cudnnAlgoMode;

    private SqueezeNet() {
    }

    @Override
    public String pretrainedUrl(PretrainedType pretrainedType) {
        if (pretrainedType == PretrainedType.IMAGENET) {
            return DL4JResources.getURLString((String)"models/squeezenet_dl4j_inference.v2.zip");
        }
        return null;
    }

    @Override
    public long pretrainedChecksum(PretrainedType pretrainedType) {
        if (pretrainedType == PretrainedType.IMAGENET) {
            return 3711411239L;
        }
        return 0L;
    }

    public ComputationGraph initPretrained(PretrainedType pretrainedType) throws IOException {
        ComputationGraph cg = (ComputationGraph)super.initPretrained(pretrainedType);
        ((GlobalPoolingLayer)cg.getLayer("global_average_pooling2d_5").conf().getLayer()).setCollapseDimensions(true);
        return cg;
    }

    @Override
    public Class<? extends Model> modelType() {
        return ComputationGraph.class;
    }

    public ComputationGraph init() {
        ComputationGraphConfiguration.GraphBuilder graph = this.graphBuilder();
        graph.addInputs(new String[]{"input"}).setInputTypes(new InputType[]{InputType.convolutional((long)this.inputShape[2], (long)this.inputShape[1], (long)this.inputShape[0])});
        ComputationGraphConfiguration conf = graph.build();
        ComputationGraph model = new ComputationGraph(conf);
        model.init();
        return model;
    }

    public ComputationGraphConfiguration.GraphBuilder graphBuilder() {
        ComputationGraphConfiguration.GraphBuilder graph = new NeuralNetConfiguration.Builder().seed(this.seed).optimizationAlgo(OptimizationAlgorithm.STOCHASTIC_GRADIENT_DESCENT).updater(this.updater).weightInit(this.weightInit).l2(5.0E-5).miniBatch(true).cacheMode(this.cacheMode).trainingWorkspaceMode(this.workspaceMode).inferenceWorkspaceMode(this.workspaceMode).convolutionMode(ConvolutionMode.Truncate).graphBuilder();
        graph.addLayer("conv1", (Layer)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)new ConvolutionLayer.Builder(new int[]{3, 3}).stride(new int[]{2, 2}).nOut(64)).cudnnAlgoMode(this.cudnnAlgoMode)).build(), new String[]{"input"}).addLayer("conv1_act", (Layer)new ActivationLayer(Activation.RELU), new String[]{"conv1"}).addLayer("pool1", (Layer)new SubsamplingLayer.Builder(SubsamplingLayer.PoolingType.MAX).kernelSize(new int[]{3, 3}).stride(new int[]{2, 2}).build(), new String[]{"conv1_act"});
        this.fireModule(graph, 2, 16, 64, "pool1");
        this.fireModule(graph, 3, 16, 64, "fire2");
        graph.addLayer("pool3", (Layer)new SubsamplingLayer.Builder(SubsamplingLayer.PoolingType.MAX).kernelSize(new int[]{3, 3}).stride(new int[]{2, 2}).build(), new String[]{"fire3"});
        this.fireModule(graph, 4, 32, 128, "pool3");
        this.fireModule(graph, 5, 32, 128, "fire4");
        graph.addLayer("pool5", (Layer)new SubsamplingLayer.Builder(SubsamplingLayer.PoolingType.MAX).kernelSize(new int[]{3, 3}).stride(new int[]{2, 2}).build(), new String[]{"fire5"});
        this.fireModule(graph, 6, 48, 192, "pool5");
        this.fireModule(graph, 7, 48, 192, "fire6");
        this.fireModule(graph, 8, 64, 256, "fire7");
        this.fireModule(graph, 9, 64, 256, "fire8");
        graph.addLayer("drop9", (Layer)new DropoutLayer.Builder(0.5).build(), new String[]{"fire9"}).addLayer("conv10", (Layer)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)new ConvolutionLayer.Builder(new int[]{1, 1}).nOut(this.numClasses)).cudnnAlgoMode(this.cudnnAlgoMode)).build(), new String[]{"drop9"}).addLayer("conv10_act", (Layer)new ActivationLayer(Activation.RELU), new String[]{"conv10"}).addLayer("avg_pool", (Layer)new GlobalPoolingLayer(PoolingType.AVG), new String[]{"conv10_act"}).addLayer("softmax", (Layer)new ActivationLayer(Activation.SOFTMAX), new String[]{"avg_pool"}).addLayer("loss", (Layer)new LossLayer.Builder(LossFunctions.LossFunction.MCXENT).build(), new String[]{"softmax"}).setOutputs(new String[]{"loss"});
        return graph;
    }

    private String fireModule(ComputationGraphConfiguration.GraphBuilder graphBuilder, int fireId, int squeeze, int expand, String input) {
        String prefix = "fire" + fireId;
        graphBuilder.addLayer(prefix + "_sq1x1", (Layer)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)new ConvolutionLayer.Builder(new int[]{1, 1}).nOut(squeeze)).cudnnAlgoMode(this.cudnnAlgoMode)).build(), new String[]{input}).addLayer(prefix + "_relu_sq1x1", (Layer)new ActivationLayer(Activation.RELU), new String[]{prefix + "_sq1x1"}).addLayer(prefix + "_exp1x1", (Layer)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)new ConvolutionLayer.Builder(new int[]{1, 1}).nOut(expand)).cudnnAlgoMode(this.cudnnAlgoMode)).build(), new String[]{prefix + "_relu_sq1x1"}).addLayer(prefix + "_relu_exp1x1", (Layer)new ActivationLayer(Activation.RELU), new String[]{prefix + "_exp1x1"}).addLayer(prefix + "_exp3x3", (Layer)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)new ConvolutionLayer.Builder(new int[]{3, 3}).nOut(expand)).convolutionMode(ConvolutionMode.Same)).cudnnAlgoMode(this.cudnnAlgoMode)).build(), new String[]{prefix + "_relu_sq1x1"}).addLayer(prefix + "_relu_exp3x3", (Layer)new ActivationLayer(Activation.RELU), new String[]{prefix + "_exp3x3"}).addVertex(prefix, (GraphVertex)new MergeVertex(), new String[]{prefix + "_relu_exp1x1", prefix + "_relu_exp3x3"});
        return prefix;
    }

    @Override
    public ModelMetaData metaData() {
        return new ModelMetaData(new int[][]{this.inputShape}, 1, ZooType.CNN);
    }

    @Override
    public void setInputShape(int[][] inputShape) {
        this.inputShape = inputShape[0];
    }

    private static long $default$seed() {
        return 1234L;
    }

    private static int[] $default$inputShape() {
        return new int[]{3, 227, 227};
    }

    private static int $default$numClasses() {
        return 0;
    }

    private static WeightInit $default$weightInit() {
        return WeightInit.RELU;
    }

    private static IUpdater $default$updater() {
        return new AdaDelta();
    }

    private static CacheMode $default$cacheMode() {
        return CacheMode.NONE;
    }

    private static WorkspaceMode $default$workspaceMode() {
        return WorkspaceMode.ENABLED;
    }

    private static ConvolutionLayer.AlgoMode $default$cudnnAlgoMode() {
        return ConvolutionLayer.AlgoMode.PREFER_FASTEST;
    }

    public static SqueezeNetBuilder builder() {
        return new SqueezeNetBuilder();
    }

    public SqueezeNet(long seed, int[] inputShape, int numClasses, WeightInit weightInit, IUpdater updater, CacheMode cacheMode, WorkspaceMode workspaceMode, ConvolutionLayer.AlgoMode cudnnAlgoMode) {
        this.seed = seed;
        this.inputShape = inputShape;
        this.numClasses = numClasses;
        this.weightInit = weightInit;
        this.updater = updater;
        this.cacheMode = cacheMode;
        this.workspaceMode = workspaceMode;
        this.cudnnAlgoMode = cudnnAlgoMode;
    }

    public static class SqueezeNetBuilder {
        private boolean seed$set;
        private long seed$value;
        private boolean inputShape$set;
        private int[] inputShape$value;
        private boolean numClasses$set;
        private int numClasses$value;
        private boolean weightInit$set;
        private WeightInit weightInit$value;
        private boolean updater$set;
        private IUpdater updater$value;
        private boolean cacheMode$set;
        private CacheMode cacheMode$value;
        private boolean workspaceMode$set;
        private WorkspaceMode workspaceMode$value;
        private boolean cudnnAlgoMode$set;
        private ConvolutionLayer.AlgoMode cudnnAlgoMode$value;

        SqueezeNetBuilder() {
        }

        public SqueezeNetBuilder seed(long seed) {
            this.seed$value = seed;
            this.seed$set = true;
            return this;
        }

        public SqueezeNetBuilder inputShape(int[] inputShape) {
            this.inputShape$value = inputShape;
            this.inputShape$set = true;
            return this;
        }

        public SqueezeNetBuilder numClasses(int numClasses) {
            this.numClasses$value = numClasses;
            this.numClasses$set = true;
            return this;
        }

        public SqueezeNetBuilder weightInit(WeightInit weightInit) {
            this.weightInit$value = weightInit;
            this.weightInit$set = true;
            return this;
        }

        public SqueezeNetBuilder updater(IUpdater updater) {
            this.updater$value = updater;
            this.updater$set = true;
            return this;
        }

        public SqueezeNetBuilder cacheMode(CacheMode cacheMode) {
            this.cacheMode$value = cacheMode;
            this.cacheMode$set = true;
            return this;
        }

        public SqueezeNetBuilder workspaceMode(WorkspaceMode workspaceMode) {
            this.workspaceMode$value = workspaceMode;
            this.workspaceMode$set = true;
            return this;
        }

        public SqueezeNetBuilder cudnnAlgoMode(ConvolutionLayer.AlgoMode cudnnAlgoMode) {
            this.cudnnAlgoMode$value = cudnnAlgoMode;
            this.cudnnAlgoMode$set = true;
            return this;
        }

        public SqueezeNet build() {
            long seed$value = this.seed$value;
            if (!this.seed$set) {
                seed$value = SqueezeNet.$default$seed();
            }
            int[] inputShape$value = this.inputShape$value;
            if (!this.inputShape$set) {
                inputShape$value = SqueezeNet.$default$inputShape();
            }
            int numClasses$value = this.numClasses$value;
            if (!this.numClasses$set) {
                numClasses$value = SqueezeNet.$default$numClasses();
            }
            WeightInit weightInit$value = this.weightInit$value;
            if (!this.weightInit$set) {
                weightInit$value = SqueezeNet.$default$weightInit();
            }
            IUpdater updater$value = this.updater$value;
            if (!this.updater$set) {
                updater$value = SqueezeNet.$default$updater();
            }
            CacheMode cacheMode$value = this.cacheMode$value;
            if (!this.cacheMode$set) {
                cacheMode$value = SqueezeNet.$default$cacheMode();
            }
            WorkspaceMode workspaceMode$value = this.workspaceMode$value;
            if (!this.workspaceMode$set) {
                workspaceMode$value = SqueezeNet.$default$workspaceMode();
            }
            ConvolutionLayer.AlgoMode cudnnAlgoMode$value = this.cudnnAlgoMode$value;
            if (!this.cudnnAlgoMode$set) {
                cudnnAlgoMode$value = SqueezeNet.$default$cudnnAlgoMode();
            }
            return new SqueezeNet(seed$value, inputShape$value, numClasses$value, weightInit$value, updater$value, cacheMode$value, workspaceMode$value, cudnnAlgoMode$value);
        }

        public String toString() {
            return "SqueezeNet.SqueezeNetBuilder(seed$value=" + this.seed$value + ", inputShape$value=" + Arrays.toString(this.inputShape$value) + ", numClasses$value=" + this.numClasses$value + ", weightInit$value=" + this.weightInit$value + ", updater$value=" + this.updater$value + ", cacheMode$value=" + this.cacheMode$value + ", workspaceMode$value=" + this.workspaceMode$value + ", cudnnAlgoMode$value=" + this.cudnnAlgoMode$value + ")";
        }
    }
}

