/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.test;

import com.google.common.base.CharMatcher;
import java.util.Collection;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.fest.assertions.Condition;

public final class MoreConditions {
    private static final CharMatcher EOLS = CharMatcher.anyOf((CharSequence)"\n\r");

    private MoreConditions() {
    }

    public static Condition<String> equalsIgnoreEOL(String text) {
        final String strippedText = EOLS.removeFrom((CharSequence)text);
        return new Condition<String>(){

            public boolean matches(String value) {
                return EOLS.removeFrom((CharSequence)value).equals(strippedText);
            }
        }.as("equal to " + strippedText);
    }

    public static Condition<Collection<?>> contains(final Object expected) {
        return new Condition<Collection<?>>(){

            public boolean matches(Collection<?> collection) {
                for (Object actual : collection) {
                    if (!EqualsBuilder.reflectionEquals((Object)expected, actual)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static Condition<Object> reflectionEqualTo(final Object expected) {
        return new Condition<Object>(){

            public boolean matches(Object actual) {
                return EqualsBuilder.reflectionEquals((Object)expected, (Object)actual);
            }
        };
    }
}

