/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.scan.filesystem;

import com.google.common.base.Function;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Collections2;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Sets;
import java.io.FileFilter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.sonar.api.scan.filesystem.FileType;

public class FileQuery {
    private final ListMultimap<String, String> attributes = ArrayListMultimap.create();
    private final Set<String> inclusions = Sets.newHashSet();
    private final Set<String> exclusions = Sets.newHashSet();

    public static FileQuery on(FileType ... types) {
        FileQuery query = new FileQuery();
        for (FileType type : types) {
            query.on("TYPE", type.name());
        }
        return query;
    }

    public static FileQuery onSource() {
        return FileQuery.on(FileType.SOURCE);
    }

    public static FileQuery onTest() {
        return FileQuery.on(FileType.TEST);
    }

    private FileQuery() {
    }

    public FileQuery on(String attribute, String ... values) {
        for (String value : values) {
            this.attributes.put((Object)attribute, (Object)value);
        }
        return this;
    }

    public Map<String, Collection<String>> attributes() {
        return this.attributes.asMap();
    }

    public Collection<FileType> types() {
        return Collections2.transform((Collection)this.attributes.get((Object)"TYPE"), (Function)new Function<String, FileType>(){

            public FileType apply(@Nullable String input) {
                return input != null ? FileType.valueOf(input) : null;
            }
        });
    }

    public Collection<String> languages() {
        return this.attributes.get((Object)"LANG");
    }

    public FileQuery onLanguage(String ... languages) {
        return this.on("LANG", languages);
    }

    public Collection<String> inclusions() {
        return this.inclusions;
    }

    public FileQuery withInclusions(String ... inclusions) {
        this.inclusions.addAll(Arrays.asList(inclusions));
        return this;
    }

    public Collection<String> exclusions() {
        return this.exclusions;
    }

    public FileQuery withExclusions(String ... exclusions) {
        this.exclusions.addAll(Arrays.asList(exclusions));
        return this;
    }

    public Collection<FileFilter> filters() {
        throw new UnsupportedOperationException("TODO");
    }

    public FileQuery withFilters(FileFilter ... filters) {
        throw new UnsupportedOperationException("TODO");
    }
}

