/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.issue.internal;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.Date;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;

public class FieldDiffs
implements Serializable {
    public static final Splitter FIELDS_SPLITTER = Splitter.on((char)',').omitEmptyStrings();
    private String userLogin;
    private Date createdAt;
    private Date updatedAt;
    private final Map<String, Diff> diffs = Maps.newLinkedHashMap();

    public Map<String, Diff> diffs() {
        return this.diffs;
    }

    public Diff get(String field) {
        return this.diffs.get(field);
    }

    @CheckForNull
    public String userLogin() {
        return this.userLogin;
    }

    public FieldDiffs setUserLogin(@Nullable String s) {
        this.userLogin = s;
        return this;
    }

    public Date createdAt() {
        return this.createdAt;
    }

    public FieldDiffs setCreatedAt(Date d) {
        this.createdAt = d;
        return this;
    }

    public Date updatedAt() {
        return this.updatedAt;
    }

    public FieldDiffs setUpdatedAt(Date d) {
        this.updatedAt = d;
        return this;
    }

    public FieldDiffs setDiff(String field, @Nullable Serializable oldValue, @Nullable Serializable newValue) {
        Diff<Serializable> diff = this.diffs.get(field);
        if (diff == null) {
            diff = new Diff<Serializable>(oldValue, newValue);
            this.diffs.put(field, diff);
        } else {
            diff.setNewValue(newValue);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        boolean notFirst = false;
        for (Map.Entry<String, Diff> entry : this.diffs.entrySet()) {
            if (notFirst) {
                sb.append(',');
            } else {
                notFirst = true;
            }
            sb.append(entry.getKey());
            sb.append('=');
            sb.append(entry.getValue().toString());
        }
        return sb.toString();
    }

    public static FieldDiffs parse(@Nullable String s) {
        FieldDiffs diffs = new FieldDiffs();
        if (!Strings.isNullOrEmpty((String)s)) {
            Iterable fields = FIELDS_SPLITTER.split((CharSequence)s);
            for (String field : fields) {
                String[] keyValues = field.split("=");
                if (keyValues.length != 2) continue;
                String[] values = keyValues[1].split("\\|");
                String oldValue = "";
                String newValue = "";
                if (values.length > 0) {
                    oldValue = Strings.nullToEmpty((String)values[0]);
                }
                if (values.length > 1) {
                    newValue = Strings.nullToEmpty((String)values[1]);
                }
                diffs.setDiff(keyValues[0], (Serializable)((Object)oldValue), (Serializable)((Object)newValue));
            }
        }
        return diffs;
    }

    public static class Diff<T extends Serializable>
    implements Serializable {
        private T oldValue;
        private T newValue;

        public Diff(@Nullable T oldValue, @Nullable T newValue) {
            this.oldValue = oldValue;
            this.newValue = newValue;
        }

        public T oldValue() {
            return this.oldValue;
        }

        public T newValue() {
            return this.newValue;
        }

        void setNewValue(T t) {
            this.newValue = t;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this.oldValue != null) {
                sb.append(this.oldValue.toString());
            }
            sb.append('|');
            if (this.newValue != null) {
                sb.append(this.newValue.toString());
            }
            return sb.toString();
        }
    }
}

