/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.workflow.condition;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import javax.annotation.Nullable;
import org.sonar.api.workflow.Review;
import org.sonar.api.workflow.WorkflowContext;
import org.sonar.api.workflow.condition.Condition;

@Beta
public final class HasReviewPropertyCondition
extends Condition {
    private final String propertyKey;

    public HasReviewPropertyCondition(String propertyKey) {
        super(false);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)propertyKey) ? 1 : 0) != 0);
        this.propertyKey = propertyKey;
    }

    public String getPropertyKey() {
        return this.propertyKey;
    }

    public boolean doVerify(@Nullable Review review, WorkflowContext context) {
        return review != null && !Strings.isNullOrEmpty((String)review.getProperties().get(this.propertyKey));
    }
}

