/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.workflow.internal;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.sonar.api.workflow.Workflow;
import org.sonar.api.workflow.condition.Condition;
import org.sonar.api.workflow.condition.ProjectPropertyCondition;
import org.sonar.api.workflow.function.Function;
import org.sonar.api.workflow.screen.Screen;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Beta
public final class DefaultWorkflow
implements Workflow {
    private Set<String> commands = Sets.newLinkedHashSet();
    private ListMultimap<String, Condition> conditionsByCommand = ArrayListMultimap.create();
    private ListMultimap<String, Function> functionsByCommand = ArrayListMultimap.create();
    private Map<String, Screen> screensByCommand = Maps.newLinkedHashMap();
    private List<String> projectPropertyKeys = Lists.newArrayList();
    private ListMultimap<String, Condition> contextConditionsByCommand = ArrayListMultimap.create();
    private ListMultimap<String, Condition> reviewConditionsByCommand = ArrayListMultimap.create();

    @Override
    public Workflow addCommand(String key) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)key) ? 1 : 0) != 0, (Object)"Empty command key");
        this.commands.add(key);
        return this;
    }

    @Override
    public Set<String> getCommands() {
        return this.commands;
    }

    public boolean hasCommand(String key) {
        return this.commands.contains(key);
    }

    public List<String> getProjectPropertyKeys() {
        return this.projectPropertyKeys;
    }

    @Override
    public List<Condition> getConditions(String commandKey) {
        return this.conditionsByCommand.get((Object)commandKey);
    }

    public List<Condition> getReviewConditions(String commandKey) {
        return this.reviewConditionsByCommand.get((Object)commandKey);
    }

    public List<Condition> getContextConditions(String commandKey) {
        return this.contextConditionsByCommand.get((Object)commandKey);
    }

    @Override
    public Workflow addCondition(String commandKey, Condition condition) {
        Preconditions.checkArgument((boolean)this.hasCommand(commandKey), (Object)("Unknown command: " + commandKey));
        Preconditions.checkNotNull((Object)condition);
        this.conditionsByCommand.put((Object)commandKey, (Object)condition);
        if (condition instanceof ProjectPropertyCondition) {
            this.projectPropertyKeys.add(((ProjectPropertyCondition)condition).getPropertyKey());
        }
        if (condition.isOnContext()) {
            this.contextConditionsByCommand.put((Object)commandKey, (Object)condition);
        } else {
            this.reviewConditionsByCommand.put((Object)commandKey, (Object)condition);
        }
        return this;
    }

    @Override
    public List<Function> getFunctions(String commandKey) {
        return this.functionsByCommand.get((Object)commandKey);
    }

    @Override
    public Workflow addFunction(String commandKey, Function function) {
        Preconditions.checkArgument((boolean)this.hasCommand(commandKey), (Object)("Unknown command: " + commandKey));
        Preconditions.checkNotNull((Object)function);
        this.functionsByCommand.put((Object)commandKey, (Object)function);
        return this;
    }

    @Override
    public Screen getScreen(String commandKey) {
        return this.screensByCommand.get(commandKey);
    }

    @Override
    public Workflow setScreen(String commandKey, Screen screen) {
        Preconditions.checkArgument((boolean)this.hasCommand(commandKey), (Object)("Unknown command: " + commandKey));
        Preconditions.checkNotNull((Object)screen);
        Preconditions.checkState((boolean)Strings.isNullOrEmpty((String)screen.getCommandKey()), (Object)("Screen is already associated with command: " + screen.getCommandKey()));
        screen.setCommandKey(commandKey);
        this.screensByCommand.put(commandKey, screen);
        return this;
    }

    public Map<String, Screen> getScreensByCommand() {
        return this.screensByCommand;
    }
}

