/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.web;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSortedSet;
import java.util.Set;

public final class FilterColumn {
    public static final String ASC = "ASC";
    public static final String DESC = "DESC";
    public static final Set<String> DIRECTIONS = ImmutableSortedSet.of((Comparable)((Object)"ASC"), (Comparable)((Object)"DESC"));
    private final String family;
    private final String key;
    private final String sortDirection;
    private final boolean variation;

    private FilterColumn(String family, String key, String sortDirection, boolean variation) {
        Preconditions.checkArgument((boolean)DIRECTIONS.contains(sortDirection), (String)"Valid directions are %s, not '%s'", (Object[])new Object[]{DIRECTIONS, sortDirection});
        this.family = family;
        this.key = key;
        this.sortDirection = sortDirection;
        this.variation = variation;
    }

    public static FilterColumn create(String family, String key, String sortDirection, boolean variation) {
        return new FilterColumn(family, key, sortDirection, variation);
    }

    public String getFamily() {
        return this.family;
    }

    public String getKey() {
        return this.key;
    }

    public String getSortDirection() {
        return this.sortDirection;
    }

    public boolean isVariation() {
        return this.variation;
    }
}

