/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.resources;

import com.google.common.annotations.Beta;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.sonar.api.BatchComponent;
import org.sonar.api.ServerComponent;
import org.sonar.api.resources.ResourceType;
import org.sonar.api.resources.ResourceTypeTree;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Beta
public final class ResourceTypes
implements BatchComponent,
ServerComponent {
    public static final Predicate<ResourceType> AVAILABLE_FOR_FILTERS = new Predicate<ResourceType>(){

        public boolean apply(ResourceType input) {
            return Boolean.TRUE.equals(input.getBooleanProperty("availableForFilters"));
        }
    };
    private final Map<String, ResourceTypeTree> treeByQualifier;
    private final Map<String, ResourceType> typeByQualifier;

    public ResourceTypes(ResourceTypeTree[] trees) {
        Preconditions.checkNotNull((Object)trees);
        HashMap treeMap = Maps.newHashMap();
        LinkedHashMap typeMap = Maps.newLinkedHashMap();
        for (ResourceTypeTree tree : trees) {
            for (ResourceType type : tree.getTypes()) {
                if (treeMap.containsKey(type.getQualifier())) {
                    throw new IllegalStateException("Qualifier " + type.getQualifier() + " is defined in several trees");
                }
                treeMap.put(type.getQualifier(), tree);
                typeMap.put(type.getQualifier(), type);
            }
        }
        this.treeByQualifier = ImmutableMap.copyOf((Map)treeMap);
        this.typeByQualifier = ImmutableMap.copyOf((Map)typeMap);
    }

    public ResourceType get(String qualifier) {
        ResourceType type = this.typeByQualifier.get(qualifier);
        return type != null ? type : ResourceType.builder(qualifier).build();
    }

    public Collection<ResourceType> getAll() {
        return this.typeByQualifier.values();
    }

    public Collection<ResourceType> getAll(Predicate<ResourceType> predicate) {
        return Collections2.filter(this.typeByQualifier.values(), predicate);
    }

    public List<String> getChildrenQualifiers(String qualifier) {
        ResourceTypeTree tree = this.getTree(qualifier);
        if (tree != null) {
            return tree.getChildren(qualifier);
        }
        return Collections.emptyList();
    }

    public List<ResourceType> getChildren(String qualifier) {
        return Lists.transform(this.getChildrenQualifiers(qualifier), (Function)new Function<String, ResourceType>(){

            public ResourceType apply(String s) {
                return (ResourceType)ResourceTypes.this.typeByQualifier.get(s);
            }
        });
    }

    public List<String> getLeavesQualifiers(String qualifier) {
        ResourceTypeTree tree = this.getTree(qualifier);
        if (tree != null) {
            return tree.getLeaves();
        }
        return Collections.emptyList();
    }

    public ResourceTypeTree getTree(String qualifier) {
        return this.treeByQualifier.get(qualifier);
    }
}

