/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.rules;

import java.util.Date;
import org.apache.commons.lang.builder.ReflectionToStringBuilder;
import org.sonar.api.resources.Resource;
import org.sonar.api.rules.ActiveRule;
import org.sonar.api.rules.Rule;
import org.sonar.api.rules.RulePriority;
import org.sonar.api.utils.Logs;

public class Violation {
    private Resource resource;
    private Rule rule;
    private String message;
    private RulePriority severity;
    private Integer lineId;
    private Double cost;
    private Date createdAt;
    private boolean switchedOff = false;
    private String checksum;
    private boolean isNew = false;
    private boolean isManual = false;
    private Integer permanentId;
    private Integer personId;

    @Deprecated
    public Violation(Rule rule) {
        this.rule = rule;
    }

    @Deprecated
    public Violation(Rule rule, Resource resource) {
        this.resource = resource;
        this.rule = rule;
    }

    public Resource getResource() {
        return this.resource;
    }

    public Violation setResource(Resource resource) {
        this.resource = resource;
        return this;
    }

    public Rule getRule() {
        return this.rule;
    }

    public Violation setRule(Rule rule) {
        this.rule = rule;
        return this;
    }

    public String getMessage() {
        return this.message;
    }

    public Violation setMessage(String message) {
        this.message = message;
        return this;
    }

    public Integer getLineId() {
        return this.lineId;
    }

    public Violation setLineId(Integer lineId) {
        if (lineId != null && lineId < 1) {
            Logs.INFO.warn("line must not be less than 1 - in future versions this will cause IllegalArgumentException");
            this.lineId = null;
        } else {
            this.lineId = lineId;
        }
        return this;
    }

    public boolean hasLineId() {
        return this.lineId != null;
    }

    public RulePriority getSeverity() {
        return this.severity;
    }

    public Violation setSeverity(RulePriority severity) {
        this.severity = severity;
        return this;
    }

    @Deprecated
    public RulePriority getPriority() {
        return this.severity;
    }

    @Deprecated
    public Violation setPriority(RulePriority priority) {
        this.severity = priority;
        return this;
    }

    public Double getCost() {
        return this.cost;
    }

    public Violation setCost(Double d) {
        if (d == null || d >= 0.0) {
            this.cost = d;
            return this;
        }
        throw new IllegalArgumentException("Cost to fix violation can't be negative or NaN");
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public Violation setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    public Violation setSwitchedOff(boolean b) {
        this.switchedOff = b;
        return this;
    }

    public boolean isSwitchedOff() {
        return this.switchedOff;
    }

    public String getChecksum() {
        return this.checksum;
    }

    public Violation setChecksum(String s) {
        this.checksum = s;
        return this;
    }

    public boolean isNew() {
        return this.isNew;
    }

    public Violation setNew(boolean b) {
        this.isNew = b;
        return this;
    }

    public boolean isManual() {
        return this.isManual;
    }

    public Violation setManual(boolean b) {
        this.isManual = b;
        return this;
    }

    public Integer getPermanentId() {
        return this.permanentId;
    }

    public Violation setPermanentId(Integer i) {
        this.permanentId = i;
        return this;
    }

    public Integer getPersonId() {
        return this.personId;
    }

    public Violation setPersonId(Integer i) {
        this.personId = i;
        return this;
    }

    public String toString() {
        return ReflectionToStringBuilder.toString((Object)this);
    }

    public static Violation create(ActiveRule activeRule, Resource resource) {
        return new Violation(activeRule.getRule()).setResource(resource);
    }

    public static Violation create(Rule rule, Resource resource) {
        return new Violation(rule).setResource(resource);
    }
}

