/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.database.model;

import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ReflectionToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.sonar.api.database.BaseIdentifiable;
import org.sonar.api.database.DatabaseSession;
import org.sonar.api.database.model.ResourceModel;

@Entity
@Table(name="snapshots")
public class Snapshot
extends BaseIdentifiable {
    public static final String STATUS_UNPROCESSED = "U";
    public static final String STATUS_PROCESSED = "P";
    @Column(name="project_id", updatable=true, nullable=true)
    private Integer resourceId;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="build_date", updatable=true, nullable=true)
    private Date buildDate;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="created_at", updatable=true, nullable=true)
    private Date createdAt;
    @Column(name="version", updatable=true, nullable=true, length=60)
    private String version;
    @Column(name="islast")
    private Boolean last = Boolean.FALSE;
    @Column(name="status")
    private String status = "U";
    @Column(name="purge_status", updatable=true, nullable=true)
    private Integer purgeStatus;
    @Column(name="scope", updatable=true, nullable=true, length=3)
    private String scope;
    @Column(name="path", updatable=true, nullable=true, length=96)
    private String path;
    @Column(name="depth", updatable=true, nullable=true)
    private Integer depth;
    @Column(name="qualifier", updatable=true, nullable=true, length=10)
    private String qualifier;
    @Column(name="root_snapshot_id", updatable=true, nullable=true)
    private Integer rootId;
    @Column(name="parent_snapshot_id", updatable=true, nullable=true)
    private Integer parentId;
    @Column(name="root_project_id", updatable=true, nullable=true)
    private Integer rootProjectId;
    @Column(name="period1_mode", updatable=true, nullable=true, length=100)
    private String period1Mode;
    @Column(name="period2_mode", updatable=true, nullable=true, length=100)
    private String period2Mode;
    @Column(name="period3_mode", updatable=true, nullable=true, length=100)
    private String period3Mode;
    @Column(name="period4_mode", updatable=true, nullable=true, length=100)
    private String period4Mode;
    @Column(name="period5_mode", updatable=true, nullable=true, length=100)
    private String period5Mode;
    @Column(name="period1_param", updatable=true, nullable=true, length=100)
    private String period1Param;
    @Column(name="period2_param", updatable=true, nullable=true, length=100)
    private String period2Param;
    @Column(name="period3_param", updatable=true, nullable=true, length=100)
    private String period3Param;
    @Column(name="period4_param", updatable=true, nullable=true, length=100)
    private String period4Param;
    @Column(name="period5_param", updatable=true, nullable=true, length=100)
    private String period5Param;
    @Column(name="period1_date", updatable=true, nullable=true)
    private Date period1Date;
    @Column(name="period2_date", updatable=true, nullable=true)
    private Date period2Date;
    @Column(name="period3_date", updatable=true, nullable=true)
    private Date period3Date;
    @Column(name="period4_date", updatable=true, nullable=true)
    private Date period4Date;
    @Column(name="period5_date", updatable=true, nullable=true)
    private Date period5Date;

    public Snapshot() {
    }

    public Snapshot(ResourceModel resource, Snapshot parent) {
        this.resourceId = resource.getId();
        this.qualifier = resource.getQualifier();
        this.scope = resource.getScope();
        if (parent == null) {
            this.path = "";
            this.depth = 0;
            this.createdAt = new Date();
        } else {
            this.parentId = parent.getId();
            this.rootId = parent.getRootId() == null ? parent.getId() : parent.getRootId();
            this.createdAt = parent.getCreatedAt();
            this.depth = parent.getDepth() + 1;
            this.path = parent.getPath() + parent.getId() + ".";
        }
        this.rootProjectId = Snapshot.guessRootProjectId(resource, parent);
    }

    private static Integer guessRootProjectId(ResourceModel resource, Snapshot parent) {
        Integer result = "TRK".equals(resource.getQualifier()) || "VW".equals(resource.getQualifier()) || "SVW".equals(resource.getQualifier()) ? (resource.getCopyResourceId() != null ? resource.getCopyResourceId() : resource.getId()) : (parent == null ? (resource.getCopyResourceId() != null ? resource.getCopyResourceId() : resource.getId()) : (parent.getRootProjectId() == null ? parent.getResourceId() : parent.getRootProjectId()));
        return result;
    }

    public Snapshot save(DatabaseSession session) {
        return session.save(this);
    }

    public Snapshot(ResourceModel resource, boolean last, String status, Date date) {
        this();
        this.setResource(resource);
        this.status = status;
        this.last = last;
        this.createdAt = date;
    }

    public Date getBuildDate() {
        return this.buildDate;
    }

    public Snapshot setBuildDate(Date d) {
        this.buildDate = d;
        return this;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public Snapshot setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    public Integer getResourceId() {
        return this.resourceId;
    }

    public Snapshot setResourceId(Integer resourceId) {
        this.resourceId = resourceId;
        return this;
    }

    public final Snapshot setResource(ResourceModel resource) {
        this.resourceId = resource.getId();
        this.scope = resource.getScope();
        this.qualifier = resource.getQualifier();
        return this;
    }

    public String getVersion() {
        return this.version;
    }

    public Snapshot setVersion(String version) {
        this.version = version;
        return this;
    }

    public Integer getParentId() {
        return this.parentId;
    }

    public Snapshot setParentId(Integer i) {
        this.parentId = i;
        return this;
    }

    public Boolean getLast() {
        return this.last;
    }

    public Snapshot setLast(Boolean last) {
        this.last = last;
        return this;
    }

    public String getStatus() {
        return this.status;
    }

    public Snapshot setStatus(String status) {
        this.status = status;
        return this;
    }

    public Integer getPurgeStatus() {
        return this.purgeStatus;
    }

    public Snapshot setPurgeStatus(Integer i) {
        this.purgeStatus = i;
        return this;
    }

    public String getScope() {
        return this.scope;
    }

    public Snapshot setScope(String scope) {
        this.scope = scope;
        return this;
    }

    public String getQualifier() {
        return this.qualifier;
    }

    public Snapshot setQualifier(String qualifier) {
        this.qualifier = qualifier;
        return this;
    }

    public Integer getRootId() {
        return this.rootId;
    }

    public Snapshot setRootId(Integer i) {
        this.rootId = i;
        return this;
    }

    public String getPath() {
        return this.path;
    }

    public Snapshot setPath(String path) {
        this.path = path;
        return this;
    }

    public Integer getDepth() {
        return this.depth;
    }

    public Integer getRootProjectId() {
        return this.rootProjectId;
    }

    public Snapshot setRootProjectId(Integer rootProjectId) {
        this.rootProjectId = rootProjectId;
        return this;
    }

    public void setDepth(Integer depth) {
        if (depth != null && depth < 0) {
            throw new IllegalArgumentException("depth can not be negative : " + depth);
        }
        this.depth = depth;
    }

    public String getPeriod1Mode() {
        return this.period1Mode;
    }

    public Snapshot setPeriod1Mode(String s) {
        this.period1Mode = s;
        return this;
    }

    public String getPeriod2Mode() {
        return this.period2Mode;
    }

    public Snapshot setPeriod2Mode(String s) {
        this.period2Mode = s;
        return this;
    }

    public String getPeriod3Mode() {
        return this.period3Mode;
    }

    public Snapshot setPeriod3Mode(String s) {
        this.period3Mode = s;
        return this;
    }

    public String getPeriod4Mode() {
        return this.period4Mode;
    }

    public Snapshot setPeriod4Mode(String s) {
        this.period4Mode = s;
        return this;
    }

    public String getPeriod5Mode() {
        return this.period5Mode;
    }

    public Snapshot setPeriod5Mode(String s) {
        this.period5Mode = s;
        return this;
    }

    public String getPeriod1Param() {
        return this.period1Param;
    }

    public Snapshot setPeriod1Param(String s) {
        this.period1Param = s;
        return this;
    }

    public String getPeriod2Param() {
        return this.period2Param;
    }

    public Snapshot setPeriod2Param(String s) {
        this.period2Param = s;
        return this;
    }

    public String getPeriod3Param() {
        return this.period3Param;
    }

    public Snapshot setPeriod3Param(String s) {
        this.period3Param = s;
        return this;
    }

    public String getPeriod4Param() {
        return this.period4Param;
    }

    public Snapshot setPeriod4Param(String s) {
        this.period4Param = s;
        return this;
    }

    public String getPeriod5Param() {
        return this.period5Param;
    }

    public Snapshot setPeriod5Param(String s) {
        this.period5Param = s;
        return this;
    }

    public Date getPeriod1Date() {
        return this.period1Date;
    }

    public Snapshot setPeriod1Date(Date period1Date) {
        this.period1Date = period1Date;
        return this;
    }

    public Date getPeriod2Date() {
        return this.period2Date;
    }

    public Snapshot setPeriod2Date(Date period2Date) {
        this.period2Date = period2Date;
        return this;
    }

    public Date getPeriod3Date() {
        return this.period3Date;
    }

    public Snapshot setPeriod3Date(Date period3Date) {
        this.period3Date = period3Date;
        return this;
    }

    public Date getPeriod4Date() {
        return this.period4Date;
    }

    public Snapshot setPeriod4Date(Date period4Date) {
        this.period4Date = period4Date;
        return this;
    }

    public Date getPeriod5Date() {
        return this.period5Date;
    }

    public Snapshot setPeriod5Date(Date period5Date) {
        this.period5Date = period5Date;
        return this;
    }

    public Snapshot setPeriodMode(int periodIndex, String s) {
        switch (periodIndex) {
            case 1: {
                this.period1Mode = s;
                break;
            }
            case 2: {
                this.period2Mode = s;
                break;
            }
            case 3: {
                this.period3Mode = s;
                break;
            }
            case 4: {
                this.period4Mode = s;
                break;
            }
            case 5: {
                this.period5Mode = s;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("Index of Snapshot.periodMode is between 1 and 5");
            }
        }
        return this;
    }

    public String getPeriodMode(int index) {
        switch (index) {
            case 1: {
                return this.period1Mode;
            }
            case 2: {
                return this.period2Mode;
            }
            case 3: {
                return this.period3Mode;
            }
            case 4: {
                return this.period4Mode;
            }
            case 5: {
                return this.period5Mode;
            }
        }
        throw new IndexOutOfBoundsException("Index of Snapshot.periodMode is between 1 and 5");
    }

    public Snapshot setPeriodModeParameter(int periodIndex, String s) {
        switch (periodIndex) {
            case 1: {
                this.period1Param = s;
                break;
            }
            case 2: {
                this.period2Param = s;
                break;
            }
            case 3: {
                this.period3Param = s;
                break;
            }
            case 4: {
                this.period4Param = s;
                break;
            }
            case 5: {
                this.period5Param = s;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("Index of Snapshot.periodModeParameter is between 1 and 5");
            }
        }
        return this;
    }

    public String getPeriodModeParameter(int periodIndex) {
        switch (periodIndex) {
            case 1: {
                return this.period1Param;
            }
            case 2: {
                return this.period2Param;
            }
            case 3: {
                return this.period3Param;
            }
            case 4: {
                return this.period4Param;
            }
            case 5: {
                return this.period5Param;
            }
        }
        throw new IndexOutOfBoundsException("Index of Snapshot.periodModeParameter is between 1 and 5");
    }

    public Snapshot setPeriodDate(int periodIndex, Date d) {
        switch (periodIndex) {
            case 1: {
                this.period1Date = d;
                break;
            }
            case 2: {
                this.period2Date = d;
                break;
            }
            case 3: {
                this.period3Date = d;
                break;
            }
            case 4: {
                this.period4Date = d;
                break;
            }
            case 5: {
                this.period5Date = d;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("Index of Snapshot.periodDate is between 1 and 5");
            }
        }
        return this;
    }

    public Date getPeriodDate(int periodIndex) {
        switch (periodIndex) {
            case 1: {
                return this.period1Date;
            }
            case 2: {
                return this.period2Date;
            }
            case 3: {
                return this.period3Date;
            }
            case 4: {
                return this.period4Date;
            }
            case 5: {
                return this.period5Date;
            }
        }
        throw new IndexOutOfBoundsException("Index of Snapshot.periodDate is between 1 and 5");
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Snapshot)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        Snapshot other = (Snapshot)obj;
        return new EqualsBuilder().append((Object)this.resourceId, (Object)other.getResourceId()).append((Object)this.createdAt, (Object)other.getCreatedAt()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.resourceId).append((Object)this.createdAt).toHashCode();
    }

    public String toString() {
        return new ReflectionToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).toString();
    }
}

