/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch;

import org.apache.commons.lang.StringUtils;
import org.sonar.api.resources.JavaFile;
import org.sonar.api.resources.JavaPackage;

public final class SquidUtils {
    private SquidUtils() {
    }

    public static JavaFile convertJavaFileKeyFromSquidFormat(String key) {
        String convertedKey;
        boolean isJavaFile = key.endsWith(".java");
        if (isJavaFile) {
            key = key.substring(0, key.length() - ".java".length());
        }
        if ((convertedKey = key.replace('/', '.')).indexOf(46) == -1 && !"".equals(convertedKey)) {
            convertedKey = "[default]." + convertedKey;
        } else if (convertedKey.indexOf(46) == -1) {
            convertedKey = "[default]";
        }
        return new JavaFile(convertedKey);
    }

    public static JavaPackage convertJavaPackageKeyFromSquidFormat(String key) {
        String convertedKey = key.replace('/', '.');
        return new JavaPackage(convertedKey);
    }

    public static String convertToSquidKeyFormat(JavaFile file) {
        String key = file.getKey();
        key = file.getParent() == null || file.getParent().isDefault() ? StringUtils.substringAfterLast((String)file.getKey(), (String)".") : StringUtils.replace((String)key, (String)".", (String)"/");
        return key + ".java";
    }
}

