/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.utils.command;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.utils.command.Command;
import org.sonar.api.utils.command.CommandException;

public final class CommandExecutor {
    private static final CommandExecutor INSTANCE = new CommandExecutor();

    private CommandExecutor() {
    }

    public static CommandExecutor create() {
        return INSTANCE;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int execute(Command command, long timeoutMilliseconds) {
        ExecutorService executorService = null;
        Process process = null;
        StreamGobbler outputGobbler = null;
        StreamGobbler errorGobbler = null;
        try {
            LoggerFactory.getLogger(this.getClass()).debug("Executing command: " + command);
            ProcessBuilder builder = new ProcessBuilder(command.toStrings());
            if (command.getDirectory() != null) {
                builder.directory(command.getDirectory());
            }
            process = builder.start();
            outputGobbler = new StreamGobbler(process.getInputStream());
            errorGobbler = new StreamGobbler(process.getErrorStream());
            outputGobbler.start();
            errorGobbler.start();
            final Process finalProcess = process;
            Callable<Integer> call = new Callable<Integer>(){

                @Override
                public Integer call() throws Exception {
                    return finalProcess.waitFor();
                }
            };
            executorService = Executors.newSingleThreadExecutor();
            Future<Integer> ft = executorService.submit(call);
            int n = ft.get(timeoutMilliseconds, TimeUnit.MILLISECONDS);
            this.waitUntilFinish(outputGobbler);
            this.waitUntilFinish(errorGobbler);
            this.closeStreams(process);
            if (executorService != null) {
                executorService.shutdown();
            }
            return n;
        }
        catch (TimeoutException te) {
            try {
                process.destroy();
                throw new CommandException(command, "Timeout exceeded: " + timeoutMilliseconds + " ms", te);
                catch (Exception e) {
                    throw new CommandException(command, (Throwable)e);
                }
            }
            catch (Throwable throwable) {
                this.waitUntilFinish(outputGobbler);
                this.waitUntilFinish(errorGobbler);
                this.closeStreams(process);
                if (executorService != null) {
                    executorService.shutdown();
                }
                throw throwable;
            }
        }
    }

    private void closeStreams(Process process) {
        if (process != null) {
            IOUtils.closeQuietly((InputStream)process.getInputStream());
            IOUtils.closeQuietly((OutputStream)process.getOutputStream());
            IOUtils.closeQuietly((InputStream)process.getErrorStream());
        }
    }

    private void waitUntilFinish(StreamGobbler thread) {
        if (thread != null) {
            try {
                thread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private static class StreamGobbler
    extends Thread {
        InputStream is;

        StreamGobbler(InputStream is) {
            super("ProcessStreamGobbler");
            this.is = is;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Logger logger = LoggerFactory.getLogger(CommandExecutor.class);
            InputStreamReader isr = new InputStreamReader(this.is);
            BufferedReader br = new BufferedReader(isr);
            try {
                String line;
                while ((line = br.readLine()) != null) {
                    logger.info(line);
                }
            }
            catch (IOException ioe) {
                logger.error("Error while reading stream", (Throwable)ioe);
            }
            finally {
                IOUtils.closeQuietly((Reader)br);
                IOUtils.closeQuietly((Reader)isr);
            }
        }
    }
}

