/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.config;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.BatchComponent;
import org.sonar.api.Properties;
import org.sonar.api.Property;
import org.sonar.api.ServerComponent;
import org.sonar.api.utils.AnnotationUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PropertyDefinitions
implements BatchComponent,
ServerComponent {
    private Map<String, Property> properties = Maps.newHashMap();
    private Map<String, String> categories = Maps.newHashMap();

    public PropertyDefinitions(Object ... components) {
        if (components != null) {
            this.addComponents(Arrays.asList(components));
        }
    }

    public PropertyDefinitions addComponents(Collection components) {
        return this.addComponents(components, "");
    }

    public PropertyDefinitions addComponents(Collection components, String defaultCategory) {
        for (Object component : components) {
            this.addComponent(component, defaultCategory);
        }
        return this;
    }

    public PropertyDefinitions addComponent(Object object) {
        return this.addComponent(object, "");
    }

    public PropertyDefinitions addComponent(Object component, String defaultCategory) {
        Property annotation;
        Properties annotations = AnnotationUtils.getClassAnnotation(component, Properties.class);
        if (annotations != null) {
            for (Property property : annotations.value()) {
                this.addProperty(property, defaultCategory);
            }
        }
        if ((annotation = AnnotationUtils.getClassAnnotation(component, Property.class)) != null) {
            this.addProperty(annotation, defaultCategory);
        }
        return this;
    }

    PropertyDefinitions addProperty(Property property) {
        return this.addProperty(property, "");
    }

    PropertyDefinitions addProperty(Property property, String defaultCategory) {
        if (!this.properties.containsKey(property.key())) {
            this.properties.put(property.key(), property);
            this.categories.put(property.key(), StringUtils.defaultIfBlank((String)property.category(), (String)defaultCategory));
        }
        return this;
    }

    public Property getProperty(String key) {
        return this.properties.get(key);
    }

    public Collection<Property> getProperties() {
        return this.properties.values();
    }

    public String getDefaultValue(String key) {
        Property prop = this.getProperty(key);
        if (prop != null) {
            return StringUtils.defaultIfEmpty((String)prop.defaultValue(), null);
        }
        return null;
    }

    public String getCategory(String key) {
        return this.categories.get(key);
    }

    public String getCategory(Property prop) {
        return this.getCategory(prop.key());
    }
}

