/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.resources;

import org.apache.commons.lang.StringUtils;
import org.sonar.api.resources.Resource;

public final class ResourceUtils {
    private ResourceUtils() {
    }

    public static boolean isView(Resource resource) {
        return ResourceUtils.isSet(resource) && "VW".equals(resource.getQualifier());
    }

    public static boolean isSubview(Resource resource) {
        return ResourceUtils.isSet(resource) && "SVW".equals(resource.getQualifier());
    }

    public static boolean isRootProject(Resource resource) {
        return "TRK".equals(resource.getQualifier());
    }

    public static boolean isModuleProject(Resource resource) {
        return "BRC".equals(resource.getQualifier());
    }

    public static boolean isPackage(Resource resource) {
        return resource != null && "PAC".equals(resource.getQualifier());
    }

    public static boolean isSet(Resource resource) {
        return resource != null && "PRJ".equals(resource.getScope());
    }

    public static boolean isSpace(Resource resource) {
        return resource != null && "DIR".equals(resource.getScope());
    }

    public static boolean isEntity(Resource resource) {
        return resource != null && "FIL".equals(resource.getScope());
    }

    public static boolean isProject(Resource resource) {
        return ResourceUtils.isSet(resource);
    }

    public static boolean isDirectory(Resource resource) {
        return ResourceUtils.isSpace(resource);
    }

    public static boolean isFile(Resource resource) {
        return ResourceUtils.isEntity(resource);
    }

    public static boolean isClass(Resource resource) {
        return "CLA".equals(resource.getQualifier());
    }

    public static boolean isUnitTestClass(Resource resource) {
        return "UTS".equals(resource.getQualifier());
    }

    public static boolean isLibrary(Resource resource) {
        return "LIB".equals(resource.getQualifier());
    }

    public static boolean isPersistable(Resource resource) {
        return StringUtils.equals((String)"PRJ", (String)resource.getScope()) || StringUtils.equals((String)"DIR", (String)resource.getScope()) || StringUtils.equals((String)"FIL", (String)resource.getScope());
    }
}

