/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.checks;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.sonar.api.resources.Resource;
import org.sonar.api.rules.Violation;
import org.sonar.api.rules.ViolationFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NoSonarFilter
implements ViolationFilter {
    private final Map<Resource, Set<Integer>> noSonarLinesByResource = new HashMap<Resource, Set<Integer>>();

    public void addResource(Resource resource, Set<Integer> noSonarLines) {
        if (resource != null && noSonarLines != null) {
            this.noSonarLinesByResource.put(resource, noSonarLines);
        }
    }

    @Override
    public boolean isIgnored(Violation violation) {
        if (violation.getResource() != null && violation.getLineId() != null) {
            Set<Integer> noSonarLines = this.noSonarLinesByResource.get(violation.getResource());
            return noSonarLines != null && noSonarLines.contains(violation.getLineId());
        }
        return false;
    }
}

