/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.rules;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.SingleValueConverter;
import com.thoughtworks.xstream.converters.basic.AbstractSingleValueConverter;
import com.thoughtworks.xstream.core.util.QuickWriter;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.xml.PrettyPrintWriter;
import com.thoughtworks.xstream.io.xml.XppDriver;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.rules.Rule;
import org.sonar.api.rules.RuleParam;
import org.sonar.api.rules.RulePriority;
import org.sonar.api.rules.RulesCategory;
import org.sonar.api.utils.SonarException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class StandardRulesXmlParser {
    public List<Rule> parse(String xml) {
        InputStream inputStream = null;
        try {
            inputStream = IOUtils.toInputStream((String)xml, (String)"UTF-8");
            List<Rule> list = this.setDefaultRulePriorities((List)this.getXStream().fromXML(inputStream));
            return list;
        }
        catch (IOException e) {
            throw new SonarException("Can't parse xml file", (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
    }

    public List<Rule> parse(Reader reader) {
        return this.setDefaultRulePriorities((List)this.getXStream().fromXML(reader));
    }

    public List<Rule> parse(InputStream input) {
        try {
            return this.setDefaultRulePriorities((List)this.getXStream().fromXML((Reader)new InputStreamReader(input, "UTF-8")));
        }
        catch (UnsupportedEncodingException e) {
            throw new SonarException("Can't parse xml file", (Throwable)e);
        }
    }

    private List<Rule> setDefaultRulePriorities(List<Rule> rules) {
        for (Rule rule : rules) {
            if (rule.getPriority() != null) continue;
            rule.setPriority(RulePriority.MAJOR);
        }
        return rules;
    }

    public String toXml(List<Rule> rules) {
        return this.getXStream().toXML(rules);
    }

    private XStream getXStream() {
        XStream xstream = new XStream((HierarchicalStreamDriver)new CDataXppDriver());
        xstream.registerConverter((SingleValueConverter)new TrimStringConverter());
        xstream.alias("rules", ArrayList.class);
        xstream.alias("categ", RulesCategory.class);
        xstream.useAttributeFor(RulesCategory.class, "name");
        xstream.aliasField("category", Rule.class, "rulesCategory");
        xstream.alias("rule", Rule.class);
        xstream.useAttributeFor(Rule.class, "key");
        xstream.useAttributeFor("priority", RulePriority.class);
        xstream.addImplicitCollection(Rule.class, "params");
        xstream.alias("param", RuleParam.class);
        xstream.useAttributeFor(RuleParam.class, "key");
        xstream.useAttributeFor(RuleParam.class, "type");
        xstream.omitField(RuleParam.class, "defaultValue");
        return xstream;
    }

    public static class TrimStringConverter
    extends AbstractSingleValueConverter {
        private final Map cache;

        public TrimStringConverter(Map map) {
            this.cache = map;
        }

        public TrimStringConverter() {
            this(Collections.synchronizedMap(new WeakHashMap()));
        }

        public boolean canConvert(Class type) {
            return type.equals(String.class);
        }

        public Object fromString(String str) {
            String trim = StringUtils.trim((String)str);
            WeakReference ref = (WeakReference)this.cache.get(trim);
            String s = ref == null ? null : ref.get();
            if (s == null) {
                this.cache.put(str, new WeakReference<String>(trim));
                s = trim;
            }
            return s;
        }
    }

    private static class XDataPrintWriter
    extends PrettyPrintWriter {
        public XDataPrintWriter(Writer writer) {
            super(writer);
        }

        protected void writeText(QuickWriter writer, String text) {
            writer.write("<![CDATA[");
            writer.write(text);
            writer.write("]]>");
        }
    }

    private static class CDataXppDriver
    extends XppDriver {
        private CDataXppDriver() {
        }

        public HierarchicalStreamWriter createWriter(Writer out) {
            return new XDataPrintWriter(out);
        }
    }
}

