/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.webtest.components;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.lang.Validate;

public class ResourceCopy {
    private static final int BUFFER_SIZE = 1024;

    public void copy(String sourcePath, String[] sourceFiles, File targetDir) throws Exception {
        InputStream is = null;
        FileOutputStream fos = null;
        try {
            targetDir.mkdirs();
            for (int i = 0; i < sourceFiles.length; ++i) {
                String sourceResourceName = sourcePath + sourceFiles[i];
                is = this.getClass().getResourceAsStream(sourceResourceName);
                File targetFile = new File(targetDir, sourceFiles[i]);
                fos = new FileOutputStream(targetFile);
                this.copy(is, fos);
                is = null;
                fos = null;
            }
        }
        catch (Exception e) {
            if (is != null) {
                is.close();
            }
            if (fos != null) {
                fos.close();
            }
            throw e;
        }
    }

    public int copy(InputStream is, OutputStream os) throws IOException {
        int n;
        Validate.notNull((Object)is, (String)"is is null");
        Validate.notNull((Object)os, (String)"os is null");
        int total = 0;
        byte[] buf = new byte[1024];
        while ((n = is.read(buf)) > 0) {
            os.write(buf, 0, n);
            total += n;
        }
        is.close();
        os.flush();
        os.close();
        return total;
    }
}

