/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.webtest.steps.verify;

import com.canoo.webtest.engine.StepFailedException;
import com.canoo.webtest.engine.xpath.XPathHelper;
import com.canoo.webtest.steps.verify.AbstractVerifyTextStep;
import com.gargoylesoftware.htmlunit.Page;
import javax.xml.xpath.XPathException;

public class VerifyXPath
extends AbstractVerifyTextStep {
    private String fXpath;

    public VerifyXPath() {
        this.setOptionalText(true);
        this.setOptionalPreviousPage(true);
    }

    public void setText(String text) {
        super.setText(text);
    }

    public String getXpath() {
        return this.fXpath;
    }

    public void setXpath(String xpath) {
        this.fXpath = xpath;
    }

    protected void verifyParameters() {
        super.verifyParameters();
        this.nullParamCheck(this.fXpath, "xpath");
    }

    public void doExecute() throws XPathException {
        this.verifyXPath();
    }

    protected boolean isComparingPathAndValue() {
        return this.getText() != null;
    }

    protected void verifyXPath() throws XPathException, StepFailedException {
        Page currentResponse = this.getContext().getCurrentResponse();
        XPathHelper xpathHelper = this.getContext().getXPathHelper();
        if (this.isComparingPathAndValue()) {
            String actualValue = xpathHelper.stringValueOf(currentResponse, this.getXpath());
            if (!this.verifyText(actualValue)) {
                throw new StepFailedException("Wrong result for xpath >" + this.fXpath + "<", this.getText(), actualValue, this);
            }
        } else {
            Object singleNode = xpathHelper.selectFirst(currentResponse, this.getXpath());
            if (singleNode == null) {
                throw new StepFailedException("xpath test: " + this.fXpath + " matched no nodes", this);
            }
            if (Boolean.FALSE.equals(singleNode)) {
                throw new StepFailedException("xpath test: " + this.fXpath + " evaluates to false", this);
            }
        }
    }
}

