/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.webtest.steps.form;

import com.canoo.webtest.engine.StepFailedException;
import com.canoo.webtest.steps.form.AbstractSetNamedFieldStep;
import com.canoo.webtest.util.ConversionUtil;
import com.canoo.webtest.util.FormUtil;
import com.gargoylesoftware.htmlunit.html.HtmlCheckBoxInput;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlForm;
import java.io.IOException;
import org.apache.log4j.Logger;

public class SetCheckbox
extends AbstractSetNamedFieldStep {
    private static final Logger LOG = Logger.getLogger(SetCheckbox.class);
    private String fChecked;

    protected HtmlForm findForm() {
        return FormUtil.findFormForField(this.getContext(), this.getFormName(), "input", "checkbox", this.getName(), this);
    }

    protected boolean keepField(HtmlElement elt) {
        if (!(elt instanceof HtmlCheckBoxInput)) {
            return false;
        }
        return this.isValueNull() || this.getValue().equals(((HtmlCheckBoxInput)elt).getValueAttribute());
    }

    public void setValue(String value) {
        super.setValue(value);
    }

    protected void setField(HtmlElement field) throws IOException {
        if (!(field instanceof HtmlCheckBoxInput)) {
            throw new StepFailedException("Found " + field.getTagName() + " when looking for checkbox", this);
        }
        boolean checked = this.isChecked();
        HtmlCheckBoxInput checkBox = (HtmlCheckBoxInput)field;
        if (checkBox.isChecked() != checked) {
            checkBox.click();
            LOG.debug((Object)((checked ? "" : "un") + "checked checkbox " + checkBox));
        }
    }

    private boolean isChecked() {
        return ConversionUtil.convertToBoolean(this.getChecked(), true);
    }

    public String getChecked() {
        return this.fChecked;
    }

    public void setChecked(String checked) {
        this.fChecked = checked;
    }
}

