/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.webtest.plugins.pdftest;

import com.canoo.webtest.engine.IStringVerifier;
import com.canoo.webtest.engine.StepFailedException;
import com.canoo.webtest.plugins.pdftest.AbstractVerifyValuePdfStep;
import com.canoo.webtest.plugins.pdftest.htmlunit.PDFField;
import com.canoo.webtest.plugins.pdftest.htmlunit.PDFPage;
import com.canoo.webtest.util.ConversionUtil;
import java.util.List;

public class PdfVerifyCheckboxFieldStep
extends AbstractVerifyValuePdfStep {
    private String fName;
    private int fPage = -1;

    public void setName(String name) {
        this.fName = name;
    }

    public String getName() {
        return this.fName;
    }

    public void setPage(int page) {
        this.fPage = page;
    }

    public int getPage() {
        return this.fPage;
    }

    protected void verifyParameters() {
        super.verifyParameters();
        this.nullParamCheck(this.getName(), "name");
    }

    protected void verifyPdf(PDFPage pdfPage) {
        List fields = this.getPage() == -1 ? pdfPage.getFields(this.getName(), PDFField.CHECKBOX) : pdfPage.getFields(this.getName(), this.getPage(), PDFField.CHECKBOX);
        if (this.getExists() != null) {
            boolean exists = ConversionUtil.convertToBoolean(this.getExists(), true);
            if (exists == fields.isEmpty()) {
                String msg = "";
                msg = fields.isEmpty() ? "No" : msg + fields.size();
                msg = msg + " checkbox field(s) found with name >" + this.getName() + "<";
                if (this.getPage() != -1) {
                    msg = msg + " on page " + this.getPage();
                }
                throw new StepFailedException(msg);
            }
        } else {
            if (fields.isEmpty()) {
                throw new StepFailedException("No checkbox field named '" + this.getName() + "' found.");
            }
            boolean regex = ConversionUtil.convertToBoolean(this.getRegex(), false);
            IStringVerifier verifier = PdfVerifyCheckboxFieldStep.getVerifier(regex);
            for (PDFField field : fields) {
                if (verifier.verifyStrings(this.getValue(), field.getValue())) continue;
                throw new StepFailedException("Wrong checkbox field value", this.getValue(), field.getValue());
            }
        }
    }
}

