/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.webtest.extension.groovy;

import com.canoo.webtest.extension.groovy.GroovyInvoker;
import com.canoo.webtest.steps.Step;
import com.canoo.webtest.util.FileUtil;
import groovy.lang.Closure;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class GroovyStep
extends Step {
    private static final Logger LOG = Logger.getLogger(GroovyStep.class);
    private File fFile;
    private Integer closureKey;
    private String fText;
    private Closure bodyClosure;
    private boolean fReplaceProperties = false;
    private static final Map closuresMap_ = new HashMap();

    public static Integer registerBodyClosure(Closure closure) {
        Integer key = closure.hashCode();
        closuresMap_.put(key, closure);
        return key;
    }

    public void execute() {
        this.bodyClosure = (Closure)closuresMap_.get(this.closureKey);
        super.execute();
    }

    public void doExecute() {
        if (this.bodyClosure != null) {
            this.bodyClosure.setDelegate((Object)new DelegateForClosureBody());
            this.bodyClosure.call();
        } else {
            String script = this.getScript();
            if (this.isReplaceProperties()) {
                script = this.getProject().replaceProperties(script);
            }
            GroovyInvoker invoker = new GroovyInvoker();
            invoker.doExecute(this, script);
        }
    }

    public boolean isReplaceProperties() {
        return this.fReplaceProperties;
    }

    public void setReplaceProperties(boolean replaceProperties) {
        this.fReplaceProperties = replaceProperties;
    }

    private String getScript() {
        String script;
        if (this.fFile != null) {
            LOG.debug((Object)("Reading script from file: " + this.fFile));
            script = FileUtil.readFileToString(this.fFile, this);
        } else {
            LOG.debug((Object)"Reading script from nested text");
            script = this.fText;
        }
        return script;
    }

    protected void verifyParameters() {
        super.verifyParameters();
        if (this.bodyClosure != null) {
            String end = " attribute not allowed when step body is provided as closure";
            this.paramCheck(this.fReplaceProperties, "\"replaceProperties\" attribute not allowed when step body is provided as closure");
            this.paramCheck(this.fFile != null, "\"file\" attribute not allowed when step body is provided as closure");
        } else {
            this.paramCheck(this.fFile == null && this.fText == null, "Either \"file\" attribute or nested groovy text must be given.");
            this.paramCheck(this.fFile != null && this.fText != null, "Only one of \"file\" attribute or nested groovy text may be given.");
        }
    }

    public void setFile(File fileName) {
        this.fFile = fileName;
    }

    public File getFile() {
        return this.fFile;
    }

    public void addText(String text) {
        this.fText = text;
    }

    public void setClosureKey(Integer key) {
        this.closureKey = key;
    }

    class DelegateForClosureBody {
        DelegateForClosureBody() {
        }

        Step getStep() {
            return GroovyStep.this;
        }
    }
}

