/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.webtest.extension;

import com.canoo.webtest.engine.StepFailedException;
import com.canoo.webtest.steps.store.BaseStoreStep;
import com.gargoylesoftware.htmlunit.ElementNotFoundException;
import com.gargoylesoftware.htmlunit.html.HtmlAnchor;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlPage;

public class StoreLinkParameter
extends BaseStoreStep {
    private String fHtmlId;
    private String fParameter;

    public void doExecute() throws Exception {
        HtmlElement elt = null;
        try {
            elt = ((HtmlPage)this.getContext().getCurrentResponse()).getHtmlElementById(this.fHtmlId);
        }
        catch (ElementNotFoundException e) {
            // empty catch block
        }
        if (elt == null || !(elt instanceof HtmlAnchor)) {
            throw new StepFailedException("No link found with id >" + this.getHtmlId() + "<", this);
        }
        HtmlAnchor webLink = (HtmlAnchor)elt;
        String value = StoreLinkParameter.extractParameterValue(webLink.getHrefAttribute(), this.getParameter());
        if (value == null) {
            throw new StepFailedException("No parameter >" + this.getParameter() + "< found in link >" + webLink.getHrefAttribute() + "<", this);
        }
        this.storeProperty(value, this.getParameter());
    }

    public static String extractParameterValue(String url, String parameterName) {
        int iQueryStart = url.indexOf(63);
        if (iQueryStart == -1) {
            return null;
        }
        String strQuery = url.substring(iQueryStart + 1);
        String[] tabParamValues = strQuery.split("&");
        for (int i = 0; i < tabParamValues.length; ++i) {
            String strTmp = tabParamValues[i];
            if (!strTmp.startsWith(parameterName + "=")) continue;
            return strTmp.substring(parameterName.length() + 1);
        }
        return null;
    }

    public void setHtmlId(String string) {
        this.fHtmlId = string;
    }

    public String getHtmlId() {
        return this.fHtmlId;
    }

    public void setParameter(String string) {
        this.fParameter = string;
    }

    public String getParameter() {
        return this.fParameter;
    }

    protected void verifyParameters() {
        super.verifyParameters();
        this.nullParamCheck(this.fHtmlId, "htmlid");
        this.nullParamCheck(this.fParameter, "parameter");
        this.nullResponseCheck();
    }
}

