/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.webtest.extension;

import com.canoo.webtest.boundary.AntBoundary;
import com.canoo.webtest.engine.Context;
import com.canoo.webtest.engine.ContextHelper;
import com.canoo.webtest.engine.StepFailedException;
import com.canoo.webtest.extension.StoreElementAttribute;
import com.canoo.webtest.interfaces.IContentFilter;
import com.canoo.webtest.interfaces.IStepWithTableLocator;
import com.canoo.webtest.interfaces.ITableLocator;
import com.canoo.webtest.steps.AbstractStepContainer;
import com.canoo.webtest.steps.locator.TableLocator;
import com.canoo.webtest.steps.locator.TableNotFoundException;
import org.apache.log4j.Logger;
import org.apache.tools.ant.Task;
import org.xml.sax.SAXException;

public abstract class AbstractProcessFiltersStep
extends AbstractStepContainer
implements IStepWithTableLocator {
    private static final Logger LOG = Logger.getLogger(AbstractProcessFiltersStep.class);
    private ITableLocator fTableLocator;
    private String fHtmlId;
    private String fXpath;

    public String getHtmlId() {
        return this.fHtmlId;
    }

    public void setHtmlId(String str) {
        this.fHtmlId = str;
    }

    public String getXpath() {
        return this.fXpath;
    }

    public void setXpath(String path) {
        this.fXpath = path;
    }

    public ITableLocator getTableLocator() {
        return this.fTableLocator;
    }

    public void addTask(Task newTask) {
        Task task = AntBoundary.maybeConfigure(newTask);
        if (task instanceof IContentFilter) {
            super.addTask(task);
        } else {
            LOG.warn((Object)("Ignoring inner step because it is not a content filter: " + task.getClass().getName()));
        }
    }

    public void addTable(TableLocator tableLocator) {
        this.addTableInternal(tableLocator);
    }

    private void addTableInternal(ITableLocator tableLocator) {
        this.fTableLocator = tableLocator;
    }

    protected void applyTableFilterIfNeeded(Context context) {
        if (this.getTableLocator() != null) {
            this.tryLocateText(context);
        }
    }

    protected void applyExtractionIfNeeded(Context context) {
        String origType = context.getCurrentResponse().getWebResponse().getContentType();
        if (this.fXpath != null || this.fHtmlId != null) {
            ContextHelper.defineAsCurrentResponse(context, StoreElementAttribute.findElement(context.getCurrentResponse(), this.getHtmlId(), this.getXpath(), LOG, this).asXml(), origType, "http:" + this.getClass().getName());
        }
    }

    private void tryLocateText(Context context) {
        String origType = context.getCurrentResponse().getWebResponse().getContentType();
        try {
            ContextHelper.defineAsCurrentResponse(context, this.getTableLocator().locateText(context, this), origType, "http:" + this.getClass().getName());
        }
        catch (TableNotFoundException tableNotFound) {
            throw new StepFailedException("Cannot find table: " + tableNotFound.toString(), this);
        }
        catch (IndexOutOfBoundsException ioobe) {
            throw new StepFailedException("Cannot find cell with supplied index in table", this);
        }
        catch (SAXException se) {
            throw new StepFailedException("Can't parse table: " + se.getMessage(), this);
        }
    }

    public boolean isPerformingAction() {
        return false;
    }
}

