/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.webstart.dependency.task;

import java.io.File;
import java.io.IOException;
import org.codehaus.mojo.webstart.dependency.JnlpDependencyConfig;
import org.codehaus.mojo.webstart.dependency.task.AbstractJnlpTask;
import org.codehaus.mojo.webstart.dependency.task.JnlpDependencyTask;
import org.codehaus.mojo.webstart.dependency.task.JnlpDependencyTaskException;
import org.codehaus.mojo.webstart.pack200.Pack200Tool;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;

@Component(role=JnlpDependencyTask.class, hint="Pack200Task", instantiationStrategy="per-lookup")
public class Pack200Task
extends AbstractJnlpTask {
    public static final String ROLE_HINT = "Pack200Task";
    @Requirement(role=Pack200Tool.class)
    private Pack200Tool pack200Tool;

    @Override
    public void check(JnlpDependencyConfig config) {
        if (config == null) {
            throw new NullPointerException("config can't be null");
        }
        if (config.getArtifact() == null) {
            throw new NullPointerException("config.artifact can't be null");
        }
        if (config.getArtifact().getFile() == null) {
            throw new NullPointerException("config.artifact.file can't be null");
        }
        if (!config.isPack200()) {
            throw new IllegalStateException("Can't unpack200 if config.isPack200 is false");
        }
    }

    @Override
    public File execute(JnlpDependencyConfig config, File file) throws JnlpDependencyTaskException {
        this.verboseLog(config, "Pack200 file: " + file);
        try {
            File result = this.pack200Tool.packJar(file, config.isGzip(), config.getPack200PassFiles());
            this.getLogger().debug("packed200 file: " + result);
            return result;
        }
        catch (IOException e) {
            throw new JnlpDependencyTaskException("Could not pack200 jars: ", e);
        }
    }
}

